/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.ObjectContainer;
import com.db4o.objectManager.v2.ClassSummaryPanel;
import com.db4o.objectManager.v2.ClassTreeListener;
import com.db4o.objectManager.v2.CloseTabListener;
import com.db4o.objectManager.v2.DatabaseSummaryPanel;
import com.db4o.objectManager.v2.MainFrame;
import com.db4o.objectManager.v2.Settings;
import com.db4o.objectManager.v2.TabType;
import com.db4o.objectManager.v2.UISession;
import com.db4o.objectManager.v2.connections.ConnectionHelper;
import com.db4o.objectManager.v2.query.QueryBarPanel;
import com.db4o.objectManager.v2.query.QueryResultsPanel;
import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectManager.v2.shortcuts.ShortcutsListener;
import com.db4o.objectManager.v2.shortcuts.TabShortCutsListener;
import com.db4o.objectManager.v2.uif_lite.component.Factory;
import com.db4o.objectManager.v2.uif_lite.panel.SimpleInternalFrame;
import com.db4o.objectManager.v2.util.DateFormatter;
import com.db4o.objectManager.v2.util.Log;
import com.db4o.objectmanager.api.DatabaseInspector;
import com.db4o.objectmanager.api.impl.DatabaseInspectorImpl;
import com.db4o.objectmanager.api.prefs.Preferences;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.jgoodies.forms.factories.Borders;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class MainPanel
extends JPanel
implements UISession {
    public static DateFormatter dateFormatter = new DateFormatter();
    private MainFrame mainFrame;
    private Settings settings;
    private ObjectContainer objectContainer;
    private Db4oConnectionSpec connectionSpec;
    private DatabaseInspector databaseInspector;
    private QueryBarPanel queryBarPanel;
    private JTabbedPane tabbedPane;
    private int queryCounter;
    private JTree classTree;
    private DatabaseSummaryPanel databaseSummaryPanel;
    private static final int MAX_TABS = 8;

    public MainPanel(MainFrame mainFrame, Settings settings, Db4oConnectionSpec connectionSpec, ObjectContainer oc) {
        super(new BorderLayout());
        this.mainFrame = mainFrame;
        this.settings = settings;
        this.connectionSpec = connectionSpec;
        this.objectContainer = oc;
        this.build();
        this.initClassTree();
        mainFrame.addKeyListener(new ShortcutsListener());
    }

    public void build() {
        this.add(this.buildMainPanel());
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildQueryPanel(), "Center");
        return panel;
    }

    private Component buildQueryPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildQueryBar(), "North");
        JSplitPane splitPane = Factory.createStrippedSplitPane(1, this.buildMainLeftPanel(), this.buildTabbedPane(), 0.2f);
        panel.add((Component)splitPane, "Center");
        return panel;
    }

    private Component buildQueryBar() {
        this.queryBarPanel = new QueryBarPanel(this);
        return this.queryBarPanel;
    }

    private JComponent buildMainLeftPanel() {
        SimpleInternalFrame sif = new SimpleInternalFrame("Stored Classes");
        sif.setPreferredSize(new Dimension(200, 300));
        sif.setBorder(Borders.DIALOG_BORDER);
        sif.add(this.buildTree());
        return sif;
    }

    private JScrollPane buildTree() {
        this.classTree = new JTree(this.createClassTreeModel());
        this.classTree.putClientProperty("JTree.lineStyle", "None");
        this.classTree.setToggleClickCount(2);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(ResourceManager.createImageIcon("icons/16x16/element.png"));
        Icon icon = ResourceManager.createImageIcon("icons/16x16/coffeebean.png");
        renderer.setOpenIcon(icon);
        renderer.setClosedIcon(icon);
        this.classTree.setCellRenderer(renderer);
        return new JScrollPane(this.classTree);
    }

    private TreeModel createClassTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Stored Classes");
        DefaultTreeModel classTreeModel = new DefaultTreeModel(root);
        return classTreeModel;
    }

    public void initClassTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.classTree.getModel().getRoot();
        DatabaseInspector inspector = this.getDatabaseInspector();
        List classesStored = inspector.getClassesStored();
        for (int i = 0; i < classesStored.size(); ++i) {
            ReflectClass storedClass = (ReflectClass)classesStored.get(i);
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode(storedClass.getName());
            root.add(parent);
            ReflectField[] fields = ReflectHelper.getDeclaredFieldsInHeirarchy(storedClass);
            for (int j = 0; j < fields.length; ++j) {
                ReflectField field = fields[j];
                parent.add(new DefaultMutableTreeNode(field.getName()));
            }
        }
        this.addClassTreeListener(new ClassTreeListener(this.queryBarPanel));
        this.classTree.setRootVisible(true);
        this.classTree.expandRow(0);
        this.classTree.setRootVisible(false);
        this.classTree.setShowsRootHandles(true);
    }

    public void addClassTreeListener(MouseListener classTreeListener) {
        this.classTree.addMouseListener(classTreeListener);
    }

    private Preferences getPreferences() {
        return Preferences.getDefault();
    }

    public void setPreference(String key, Object pref) {
        this.getPreferences().setPreference(key, pref);
    }

    public Object getPreferenceForDatabase(String key) {
        return this.getPreferences().getPreference(this.connectionSpec.getFullPath() + "/" + key);
    }

    public void setPreferenceForDatabase(String key, Object pref) {
        this.getPreferences().setPreference(this.connectionSpec.getFullPath() + "/" + key, pref);
    }

    public Object getPreference(String key) {
        return this.getPreferences().getPreference(key);
    }

    public ObjectContainer getObjectContainer() {
        return this.objectContainer;
    }

    public void closeObjectContainer() {
        if (this.objectContainer != null) {
            this.objectContainer.close();
            this.objectContainer = null;
        }
    }

    public Db4oConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    private Component buildTabbedPane() {
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tabbedPane.addKeyListener(new TabShortCutsListener(this.tabbedPane));
        this.tabbedPane.addMouseListener(new CloseTabListener(this.tabbedPane));
        this.addTabs(this.tabbedPane);
        return this.tabbedPane;
    }

    private void addTabs(JTabbedPane tabbedPane) {
        this.databaseSummaryPanel = new DatabaseSummaryPanel(this, this.connectionSpec, this.getDatabaseInspector());
        tabbedPane.addTab("Home", this.createTabIcon(TabType.home.icon()), this.databaseSummaryPanel);
    }

    private Icon createTabIcon(String iconImg) {
        return ResourceManager.createImageIcon("icons/16x16/" + iconImg);
    }

    public void addTab(TabType tabType, String name, Component p) {
        this.tabbedPane.addTab(name, this.createTabIcon(tabType.icon()), p);
        this.tabbedPane.setSelectedComponent(p);
        if (this.tabbedPane.getTabCount() > 8) {
            this.tabbedPane.remove(1);
        }
    }

    public boolean isLocal() {
        return !this.connectionSpec.isRemote();
    }

    private Component buildToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(true);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.putClientProperty("jgoodies.headerStyle", this.settings.getToolBarHeaderStyle());
        toolBar.putClientProperty("Plastic.borderStyle", this.settings.getToolBarPlasticBorderStyle());
        toolBar.putClientProperty("jgoodies.windows.borderStyle", this.settings.getToolBarWindowsBorderStyle());
        toolBar.putClientProperty("Plastic.is3D", this.settings.getToolBar3DHint());
        toolBar.add(this.createToolBarButton("backward.gif", "Back"));
        AbstractButton button = this.createToolBarButton("forward.gif", "Next");
        button.setEnabled(false);
        toolBar.add(button);
        toolBar.add(this.createToolBarButton("home.gif", "Home"));
        toolBar.addSeparator();
        OpenFileActionListener openAction = new OpenFileActionListener();
        button = this.createToolBarButton("open.gif", "Open", openAction, KeyStroke.getKeyStroke(79, 128));
        button.addActionListener(openAction);
        toolBar.add(button);
        toolBar.add(this.createToolBarButton("print.gif", "Print"));
        toolBar.add(this.createToolBarButton("refresh.gif", "Update"));
        toolBar.addSeparator();
        button = this.createToolBarButton("help.gif", "Open Help");
        button.addActionListener(this.createHelpActionListener());
        toolBar.add(button);
        return toolBar;
    }

    protected AbstractButton createToolBarButton(String iconName, String toolTipText) {
        JButton button = new JButton(ResourceManager.createImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    private AbstractButton createToolBarButton(String iconName, String toolTipText, ActionListener action, KeyStroke keyStroke) {
        AbstractButton button = this.createToolBarButton(iconName, toolTipText);
        button.registerKeyboardAction(action, keyStroke, 2);
        return button;
    }

    protected AbstractButton createToolBarRadioButton(String iconName, String toolTipText) {
        JToggleButton button = new JToggleButton(ResourceManager.createImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public void setConnectionSpec(Db4oConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
        this.initClassTree();
    }

    public DatabaseInspector getDatabaseInspector() {
        if (this.databaseInspector == null) {
            this.databaseInspector = new DatabaseInspectorImpl(this.getObjectContainer());
        }
        return this.databaseInspector;
    }

    public void displayResults(String query) {
        QueryResultsPanel p = new QueryResultsPanel(this);
        this.addTab(TabType.query, "Query " + ++this.queryCounter, p);
        p.displayResults(query);
    }

    public void showClassSummary(String className) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ClassSummaryPanel csp;
            Component c = this.tabbedPane.getComponentAt(i);
            if (!(c instanceof ClassSummaryPanel) || !(csp = (ClassSummaryPanel)c).getClassName().equals(className)) continue;
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
        ClassSummaryPanel panel = new ClassSummaryPanel(this, this.getDatabaseInspector(), className);
        this.addTab(TabType.classSummary, "Class: " + className, panel);
    }

    public void reopen() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (!(c instanceof QueryResultsPanel)) continue;
            this.tabbedPane.remove(c);
            --i;
        }
        this.objectContainer.close();
        this.databaseInspector = null;
        try {
            this.objectContainer = ConnectionHelper.connect(this.mainFrame, this.connectionSpec);
        }
        catch (Exception e) {
            Log.addException(e);
            e.printStackTrace();
            this.mainFrame.close();
            return;
        }
        TreeModel treeModel = this.createClassTreeModel();
        this.classTree.setModel(treeModel);
        this.initClassTree();
    }

    protected ActionListener createHelpActionListener() {
        return null;
    }

    private final class OpenFileActionListener
    implements ActionListener {
        private OpenFileActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new JFileChooser().showOpenDialog(MainPanel.this);
        }
    }
}

