/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.ObjectContainer;
import com.db4o.objectManager.v2.ConnectedMenuBar;
import com.db4o.objectManager.v2.Dashboard;
import com.db4o.objectManager.v2.MainPanel;
import com.db4o.objectManager.v2.Settings;
import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MainFrame
extends JFrame
implements WindowListener {
    protected static final Dimension PREFERRED_SIZE = LookUtils.IS_LOW_RESOLUTION ? new Dimension(650, 510) : new Dimension(730, 560);
    private static String WINDOW_TITLE = Dashboard.TITLE;
    private final Settings settings;
    private Db4oConnectionSpec connectionSpec;
    private MainPanel mainPanel;

    protected MainFrame(Settings settings, Db4oConnectionSpec connectionSpec, ObjectContainer oc) {
        super(WINDOW_TITLE + " - " + connectionSpec.getPath());
        this.settings = settings;
        this.connectionSpec = connectionSpec;
        this.configureUI();
        this.build(oc);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
    }

    private static MainFrame createDefaultFrame(Settings settings, Dimension frameSize, Point frameLocation, Db4oConnectionSpec connectionSpec, ObjectContainer oc) {
        MainFrame instance = new MainFrame(settings, connectionSpec, oc);
        if (frameSize != null) {
            instance.setSize(frameSize);
        } else {
            instance.setSize(PREFERRED_SIZE);
        }
        if (frameLocation != null) {
            instance.setLocation(frameLocation);
        } else {
            instance.locateOnScreen(instance);
        }
        instance.setVisible(true);
        return instance;
    }

    public static MainFrame createDefaultFrame(Dimension frameSize, Point frameLocation, Db4oConnectionSpec connectionSpec, ObjectContainer oc) {
        return MainFrame.createDefaultFrame(MainFrame.createDefaultSettings(), frameSize, frameLocation, connectionSpec, oc);
    }

    static Settings createDefaultSettings() {
        Settings settings = Settings.createDefault();
        return settings;
    }

    private void configureUI() {
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        Options.setUseNarrowButtons((boolean)this.settings.isUseNarrowButtons());
        Options.setTabIconsEnabled((boolean)this.settings.isTabIconsEnabled());
        UIManager.put("jgoodies.popupDropShadowEnabled", this.settings.isPopupDropShadowEnabled());
        LookAndFeel selectedLaf = this.settings.getSelectedLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)this.settings.getSelectedTheme());
            PlasticLookAndFeel.setTabStyle((String)this.settings.getPlasticTabStyle());
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled((boolean)this.settings.isPlasticHighContrastFocusEnabled());
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        try {
            UIManager.setLookAndFeel(selectedLaf);
        }
        catch (Exception e) {
            System.out.println("Can't change L&F: " + e);
        }
    }

    private void build(ObjectContainer oc) {
        this.setContentPane(this.buildContentPane(oc));
        this.setJMenuBar(new ConnectedMenuBar(this, this.settings, Dashboard.createHelpActionListener(this), Dashboard.createAboutActionListener(this)));
        this.setIconImage(ResourceManager.createImageIcon("icons/plain/16x16/data.png", "database").getImage());
    }

    private JComponent buildContentPane(ObjectContainer oc) {
        this.mainPanel = new MainPanel(this, this.settings, this.connectionSpec, oc);
        return this.mainPanel;
    }

    protected void locateOnScreen(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public void setConnectionInfo(Db4oConnectionSpec connectionInfo) {
        this.mainPanel.setConnectionSpec(connectionInfo);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public ObjectContainer getObjectContainer() {
        return this.mainPanel.getObjectContainer();
    }

    public Db4oConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public void closeObjectContainer() {
        this.mainPanel.closeObjectContainer();
    }

    public void exit() {
        this.close();
        Dashboard.exit();
    }

    public void close() {
        this.mainPanel.closeObjectContainer();
        this.dispose();
    }
}

