/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.Db4o;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.objectManager.v2.UISession;
import com.db4o.objectmanager.api.helpers.ReflectHelper2;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FieldInfoTableModel
extends DefaultTableModel
implements TableModel,
TableModelListener {
    private UISession session;
    private String className;
    static String[] columns = new String[]{"Name", "Type", "Indexed?"};
    private boolean editMode;
    private boolean working;

    public FieldInfoTableModel(UISession session, String className) {
        super(columns, 0);
        this.session = session;
        this.className = className;
        StoredField[] fields = this.getStoredFields(className);
        super.setRowCount(fields.length);
        int r = 0;
        int c = 0;
        for (int i = 0; i < fields.length; ++i) {
            StoredField field = fields[i];
            c = 0;
            this.setValueAt(field.getName(), r, c++);
            if (field.getStoredType() != null) {
                this.setValueAt(field.getStoredType().getName(), r, c++);
                if (!field.getStoredType().isCollection() && !field.getStoredType().isArray()) {
                    this.setValueAt(new Boolean(field.hasIndex()), r, c++);
                } else {
                    this.setValueAt(null, r, c++);
                }
            }
            ++r;
        }
        this.addTableModelListener(this);
    }

    private StoredField[] getStoredFields(String className) {
        StoredClass storedClass = this.session.getObjectContainer().ext().storedClass((Object)className);
        StoredField[] fields = ReflectHelper.getDeclaredFieldsInHeirarchy(storedClass);
        return fields;
    }

    public Class getColumnClass(int column) {
        if (column == 2) {
            return Boolean.class;
        }
        return super.getColumnClass(column);
    }

    public boolean isCellEditable(int row, int column) {
        if (!this.working && this.editMode) {
            if (column == 0) {
                return true;
            }
            if (column == 2 && ReflectHelper2.isIndexable((StoredField)this.getStoredFields(this.className)[row])) {
                return true;
            }
        }
        return false;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public void tableChanged(TableModelEvent e) {
        this.working = true;
        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        Object aValue = model.getValueAt(row, column);
        if (column == 0) {
            if (aValue instanceof String) {
                StoredField[] fields = this.getStoredFields(this.className);
                this.renameField(fields[row], (String)aValue);
            } else {
                System.err.println("Invalid type for renaming!!! Report bug at http://tracker.db4o.com/jira");
            }
            this.session.reopen();
        } else if (column == 2) {
            Boolean b = (Boolean)aValue;
            StoredField[] fields = this.getStoredFields(this.className);
            StoredField field = fields[row];
            Db4o.configure().objectClass((Object)this.className).objectField(field.getName()).indexed(b.booleanValue());
            this.session.reopen();
        }
        this.working = false;
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
    }

    private void renameField(StoredField field, String newName) {
        field.rename(newName);
        this.session.getObjectContainer().commit();
        this.session.reopen();
    }
}

