/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.ObjectContainer;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.objectManager.v2.MainFrame;
import com.db4o.objectManager.v2.Settings;
import com.db4o.objectManager.v2.connections.ConnectionForm;
import com.db4o.objectManager.v2.connections.DashboardMenuBar;
import com.db4o.objectManager.v2.connections.DashboardWindowListener;
import com.db4o.objectManager.v2.custom.BackgroundPanel;
import com.db4o.objectManager.v2.custom.ProgressDialog;
import com.db4o.objectManager.v2.maint.DefragTask;
import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectManager.v2.uiHelper.OptionPaneHelper;
import com.db4o.objectManager.v2.uiHelper.SwingWorker;
import com.db4o.objectManager.v2.util.Log;
import com.db4o.objectmanager.api.prefs.Preferences;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.jgoodies.looks.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class Dashboard {
    public static final String COPYRIGHT = "\u00a9 2007 db4objects Inc. All Rights Reserved.";
    public static final String VERSION = Dashboard.getVersion();
    public static final String TITLE = "ObjectManager " + VERSION;
    private JFrame frame;
    private Settings settings;
    private ConnectionForm connectionForm;
    private static Map openMap = new HashMap();
    private static Dashboard instance;

    public static void main(String[] args) {
        try {
            Preferences pref = Preferences.getDefault();
        }
        catch (DatabaseFileLockedException e) {
            OptionPaneHelper.showErrorMessage(null, "Another instance of ObjectManager is currently open. Only one instance can be open at a time. You can connect to multiple databases through the same instance.", "Error Opening Database");
            return;
        }
        catch (Exception e) {
            OptionPaneHelper.showErrorMessage(null, "An error occurred while opening ObjectManager settings: " + e.getMessage(), "Error Opening Database");
            return;
        }
        instance = new Dashboard();
        instance.configureUI();
        instance.buildInterface();
    }

    private static String getVersion() {
        URL url = Dashboard.class.getResource("Version");
        if (url != null) {
            try {
                Properties props = new Properties();
                props.load(url.openStream());
                return (String)props.get("version");
            }
            catch (IOException e) {
                System.out.println("Could not get version of ObjectManager.");
            }
        }
        return null;
    }

    private void configureUI() {
        this.settings = MainFrame.createDefaultSettings();
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        String lafName = Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
    }

    private void buildInterface() {
        this.frame = new JFrame();
        this.frame.setIconImage(ResourceManager.createImageIcon("icons/plain/16x16/data.png", "database").getImage());
        this.frame.setJMenuBar(this.buildMenuBar());
        this.frame.setContentPane(this.buildContentPane());
        this.frame.setSize(600, 510);
        this.frame.setResizable(false);
        this.locateOnScreen(this.frame);
        this.frame.setTitle(TITLE);
        this.frame.addWindowListener(new DashboardWindowListener(this));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    private void locateOnScreen(Frame frame) {
        Dimension paneSize = frame.getSize();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        frame.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    private JMenuBar buildMenuBar() {
        DashboardMenuBar dashboardMenuBar = new DashboardMenuBar(this, this.settings, Dashboard.createHelpActionListener(this.frame), Dashboard.createAboutActionListener(this.frame));
        return dashboardMenuBar;
    }

    private JComponent buildContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildConnectionsPanel(), "Center");
        return panel;
    }

    private Component buildConnectionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String logoPath = "db4ologo.png";
        ImageIcon icon = ResourceManager.createImageIcon(logoPath, "db4o");
        JLabel label1 = new JLabel(icon, 2);
        panel.add((Component)label1, "North");
        BackgroundPanel backgroundPanel = new BackgroundPanel();
        this.connectionForm = new ConnectionForm(this);
        backgroundPanel.add(this.connectionForm.getPanel());
        panel.add((Component)backgroundPanel, "Center");
        return panel;
    }

    private JScrollPane createStrippedScrollPane(Component c) {
        JScrollPane scrollPane = new JScrollPane(c);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    private Component createCenteredLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(0);
        label.setBorder(new EmptyBorder(3, 3, 3, 3));
        return label;
    }

    public void showError(String msg) {
        JOptionPane.showMessageDialog(this.frame, "msg", "Error", 0);
    }

    public static ActionListener createHelpActionListener(Component frame) {
        return new HelpActionListener(frame);
    }

    public static ActionListener createAboutActionListener(Component frame) {
        return new AboutActionListener(frame);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void connectToFile(String dataFile) {
        this.connectionForm.connectToFile(dataFile);
    }

    public static void close() {
        for (Object key : openMap.keySet()) {
            ObjectContainer oc = (ObjectContainer)openMap.get(key);
            oc.close();
        }
        openMap.clear();
        Preferences.close();
    }

    public static void exit() {
        Dashboard.close();
        System.exit(0);
    }

    public void addOpenConnection(Db4oConnectionSpec connectionSpec, ObjectContainer oc) {
        openMap.put(connectionSpec.getFullPath(), oc);
    }

    public static void open(Db4oConnectionSpec connectionSpec) {
        Dashboard.instance.connectionForm.connectAndOpenFrame(connectionSpec);
    }

    public static void defragment(final Db4oConnectionSpec connectionSpec) {
        try {
            final ProgressDialog pd = new ProgressDialog(Dashboard.instance.frame, "Defragment", true);
            pd.setIndeterminate(true);
            pd.setStringPainted(true);
            pd.setString("Defragging Database...");
            SwingWorker worker = new SwingWorker(){
                boolean successful = true;

                public Object construct() {
                    try {
                        return new DefragTask(connectionSpec);
                    }
                    catch (Exception e1) {
                        this.successful = false;
                        OptionPaneHelper.showErrorMessage(instance.frame, "Error occurred during defragment: \n\n" + e1.getMessage(), "Error During Defragment");
                        e1.printStackTrace();
                        Log.addException(e1);
                        return null;
                    }
                }

                public void finished() {
                    super.finished();
                    pd.dispose();
                    if (this.successful) {
                        OptionPaneHelper.showSuccessDialog(instance.frame, "Defragment was successful!", "Defragment Complete");
                    }
                    Dashboard.open(connectionSpec);
                }
            };
            worker.start();
            pd.setVisible(true);
        }
        catch (Exception e1) {
            OptionPaneHelper.showErrorMessage(Dashboard.instance.frame, e1.toString() + "\n\n" + e1.getMessage(), "Error During Defragment");
            e1.printStackTrace();
        }
    }

    private static final class HelpActionListener
    implements ActionListener {
        private Component frame;

        public HelpActionListener(Component frame) {
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(this.frame, "Please visit our online help at: \nhttp://developer.db4o.com/DocsWiki/view.aspx/Reference/Object_Manager_For_db4o/Installation");
        }
    }

    private static final class AboutActionListener
    implements ActionListener {
        private Component frame;

        public AboutActionListener(Component frame) {
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(this.frame, "db4o Object Manager\nVersion: " + VERSION + "\n" + Dashboard.COPYRIGHT + "\n\n");
        }
    }
}

