/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.objectManager.v2.FieldInfoTableModel;
import com.db4o.objectManager.v2.UISession;
import com.db4o.objectManager.v2.custom.BorderedFormPanel;
import com.db4o.objectManager.v2.custom.BorderedPanel;
import com.db4o.objectmanager.api.DatabaseInspector;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ClassSummaryPanel
extends JPanel {
    private DatabaseInspector databaseInspector;
    private UISession session;
    private String className;
    private FieldInfoTableModel classModel;
    private static final String EDIT = "edit";
    private static final String STOP_EDIT = "stop";
    private Button editButton;

    public ClassSummaryPanel(UISession session, DatabaseInspector databaseInspector, String className) {
        super(new BorderLayout());
        this.session = session;
        this.className = className;
        this.setOpaque(false);
        this.setBorder(Borders.DIALOG_BORDER);
        this.databaseInspector = databaseInspector;
        this.add(this.buildMain());
    }

    private Component buildMain() {
        Box box = new Box(3);
        box.add(this.buildClassStats());
        box.add(this.buildFieldInfo());
        return box;
    }

    private Component buildClassStats() {
        BorderedFormPanel builder = new BorderedFormPanel("Class Statistics");
        builder.append("Number of Objects:", new JLabel(this.databaseInspector.getNumberOfObjectsForClass(this.className) + ""));
        return builder.getPanel();
    }

    private Component buildFieldInfo() {
        BorderedPanel builder = new BorderedPanel("Fields");
        JPanel verticalPanel = new JPanel();
        verticalPanel.setLayout(new BoxLayout(verticalPanel, 3));
        this.classModel = this.createFieldModel();
        JTable table = new JTable(this.classModel);
        TableColumn col = table.getColumnModel().getColumn(0);
        int width = 200;
        col.setPreferredWidth(width);
        JScrollPane scrollPane = new JScrollPane(table);
        verticalPanel.add(scrollPane);
        if (this.session.isLocal()) {
            this.editButton = new Button("Edit");
            this.editButton.setActionCommand(EDIT);
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(ClassSummaryPanel.EDIT)) {
                        ClassSummaryPanel.this.editButton.setActionCommand(ClassSummaryPanel.STOP_EDIT);
                        ClassSummaryPanel.this.editButton.setForeground(new Color(39219));
                        ClassSummaryPanel.this.editButton.setFont(ClassSummaryPanel.this.editButton.getFont().deriveFont(1));
                        ClassSummaryPanel.this.editButton.setLabel("Stop Editing");
                        ClassSummaryPanel.this.classModel.setEditMode(true);
                    } else {
                        ClassSummaryPanel.this.classModel.setEditMode(false);
                        ClassSummaryPanel.this.editButton.setForeground(Color.BLACK);
                        ClassSummaryPanel.this.editButton.setFont(ClassSummaryPanel.this.editButton.getFont().deriveFont(0));
                        ClassSummaryPanel.this.editButton.setLabel("Edit");
                        ClassSummaryPanel.this.editButton.setActionCommand(ClassSummaryPanel.EDIT);
                    }
                }
            });
            verticalPanel.add(this.editButton);
        }
        builder.add(verticalPanel);
        return builder.getPanel();
    }

    private FieldInfoTableModel createFieldModel() {
        FieldInfoTableModel tableModel = new FieldInfoTableModel(this.session, this.className);
        return tableModel;
    }

    public String getClassName() {
        return this.className;
    }
}

