/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.nodes.field;

import com.db4o.objectmanager.model.IDatabase;
import com.db4o.objectmanager.model.nodes.IModelNode;
import com.db4o.objectmanager.model.nodes.field.FieldNode;
import com.db4o.objectmanager.model.nodes.field.FieldNodeFactory;
import com.db4o.objectmanager.model.nodes.partition.PartitionFieldNodeFactory;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectMethod;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapFieldNode
extends FieldNode {
    private static Logger logger = Logger.getLogger(MapFieldNode.class.getName());
    private static final GetStrategy[] STRATEGIES = new GetStrategy[]{new GetStrategy("keySet", "get")};
    private ReflectMethod _keySetMethod;
    private ReflectMethod _getMethod;

    public static IModelNode tryToCreate(String string, Object object, IDatabase iDatabase) {
        for (int i = 0; i < STRATEGIES.length; ++i) {
            IModelNode iModelNode = MapFieldNode.tryToCreate(STRATEGIES[i], string, object, iDatabase);
            if (iModelNode == null) continue;
            return iModelNode;
        }
        return null;
    }

    public static IModelNode tryToCreate(GetStrategy getStrategy, String string, Object object, IDatabase iDatabase) {
        MapFieldNode mapFieldNode;
        ReflectClass reflectClass = iDatabase.reflector().forObject(object);
        ReflectMethod reflectMethod = null;
        ReflectMethod reflectMethod2 = null;
        ReflectClass reflectClass2 = iDatabase.reflector().forName("java.lang.Object");
        reflectMethod = reflectClass.getMethod(getStrategy.keySetMethod, new ReflectClass[0]);
        reflectMethod2 = reflectClass.getMethod(getStrategy.getMethod, new ReflectClass[]{reflectClass2});
        if (reflectMethod == null || reflectMethod2 == null) {
            return null;
        }
        try {
            mapFieldNode = new MapFieldNode(string, reflectClass, object, reflectMethod, reflectMethod2, iDatabase);
            mapFieldNode.iterator();
        }
        catch (IllegalStateException illegalStateException) {
            logger.log(Level.SEVERE, "Unable to invoke 'iterator()'", illegalStateException);
            return null;
        }
        return mapFieldNode;
    }

    private Iterator iterator() {
        Set set;
        try {
            set = (Set)this._keySetMethod.invoke(this.value, new Object[0]);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Unable to invoke 'keySet'", exception);
            throw new IllegalStateException();
        }
        return set.iterator();
    }

    private Object get(Object object) {
        Object object2;
        try {
            object2 = this._getMethod.invoke(this.value, new Object[]{object});
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Unable to invoke 'get'", exception);
            throw new IllegalStateException();
        }
        return object2;
    }

    public MapFieldNode(String string, ReflectClass reflectClass, Object object, ReflectMethod reflectMethod, ReflectMethod reflectMethod2, IDatabase iDatabase) {
        super(string, reflectClass, object, iDatabase);
        this._keySetMethod = reflectMethod;
        this._getMethod = reflectMethod2;
    }

    public boolean hasChildren() {
        return this.iterator().hasNext();
    }

    public IModelNode[] children() {
        Object object;
        LinkedList<IModelNode> linkedList = new LinkedList<IModelNode>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            linkedList.addLast(FieldNodeFactory.construct(object.toString(), this._database.reflector().forName("java.lang.Object"), this.get(object), this._database));
        }
        object = new IModelNode[linkedList.size()];
        int n = 0;
        for (IModelNode iModelNode : linkedList) {
            object[n] = iModelNode;
            ++n;
        }
        return PartitionFieldNodeFactory.create((IModelNode[])object, 0, ((Object)object).length, this._database);
    }

    public String getText() {
        String string = this._database.reflector().forObject(this.value).getName() + " (id=" + this._database.getId(this.value) + ")";
        return this._fieldName.equals("") ? string : this._fieldName + ": " + string;
    }

    public boolean isEditable() {
        return false;
    }

    public void printXmlValueNode(PrintStream printStream) {
        printStream.print("<" + this.getNodeName() + " id=\"" + this.getId() + "\">");
        printStream.print("</" + this.getNodeName() + ">");
    }

    public boolean shouldIndent() {
        return true;
    }

    private static class GetStrategy {
        final String keySetMethod;
        final String getMethod;

        GetStrategy(String string, String string2) {
            this.keySetMethod = string;
            this.getMethod = string2;
        }
    }
}

