/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.nodes.field;

import com.db4o.objectmanager.model.IDatabase;
import com.db4o.objectmanager.model.nodes.IModelNode;
import com.db4o.objectmanager.model.nodes.field.FieldNode;
import com.db4o.objectmanager.model.nodes.field.FieldNodeFactory;
import com.db4o.objectmanager.model.nodes.field.XmlEntity;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class InstanceNode
implements IModelNode {
    private ReflectClass _clazz = null;
    private Object _instance = null;
    private IDatabase _database;
    private boolean showType;

    public InstanceNode(Object object, IDatabase iDatabase) {
        if (object == null || iDatabase == null) {
            throw new IllegalArgumentException("InstanceNode: Null constructor argument");
        }
        this._instance = object;
        this._clazz = iDatabase.reflector().forObject(object);
        this._database = iDatabase;
        iDatabase.activate(object);
    }

    public InstanceNode(long l, IDatabase iDatabase) {
        this(iDatabase.byId(l), iDatabase);
    }

    public IDatabase getDatabase() {
        return this._database;
    }

    public IModelNode[] children() {
        HashMap<String, IModelNode> hashMap = new HashMap<String, IModelNode>();
        ArrayList<IModelNode> arrayList = new ArrayList<IModelNode>();
        for (ReflectClass reflectClass = this._clazz; reflectClass != null; reflectClass = reflectClass.getSuperclass()) {
            ReflectField[] reflectFieldArray = reflectClass.getDeclaredFields();
            for (int i = 0; i < reflectFieldArray.length; ++i) {
                if (reflectFieldArray[i].isTransient()) continue;
                Object object = FieldNode.field(reflectFieldArray[i], this._instance);
                IModelNode iModelNode = FieldNodeFactory.construct(reflectFieldArray[i].getName(), reflectFieldArray[i].getFieldType(), object, this._database);
                IModelNode iModelNode2 = (IModelNode)hashMap.get(iModelNode.getName());
                if (iModelNode2 != null) {
                    iModelNode2.setShowType(true);
                    iModelNode.setShowType(true);
                } else {
                    hashMap.put(iModelNode.getName(), iModelNode);
                }
                arrayList.add(iModelNode);
            }
        }
        return arrayList.toArray(new IModelNode[arrayList.size()]);
    }

    public String getText() {
        long l = this._database.getId(this._instance);
        String string = "";
        if (this.showType) {
            string = "(" + this._database.reflector().forObject(this._instance).getName() + ") ";
        }
        if (l > 0L) {
            return string + this._instance.toString() + " (id=" + this._database.getId(this._instance) + ")";
        }
        return string + this._instance.toString();
    }

    public String getValueString() {
        return this._instance.toString();
    }

    public String getName() {
        return this.showType ? "(" + this._database.reflector().forObject(this._instance).getName() + ")" : "";
    }

    public boolean hasChildren() {
        for (ReflectClass reflectClass = this._database.reflector().forObject(this._instance); reflectClass != null; reflectClass = reflectClass.getSuperclass()) {
            if (reflectClass.getDeclaredFields().length <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this._instance.equals(((InstanceNode)object)._instance);
    }

    public int hashCode() {
        return this._instance.hashCode();
    }

    public void setShowType(boolean bl) {
        this.showType = bl;
    }

    public boolean isEditable() {
        return false;
    }

    public Object getEditValue() {
        return null;
    }

    public long getId() {
        long l = this._database.getId(this._instance);
        return l;
    }

    public void printXmlReferenceNode(PrintStream printStream) {
    }

    public void printXmlStart(PrintStream printStream) {
        printStream.println("<" + this._clazz.getName() + ">");
    }

    public void printXmlEnd(PrintStream printStream) {
        printStream.println("</" + this._clazz.getName() + ">");
    }

    public void printXmlValueNode(PrintStream printStream) {
        printStream.print("<" + this._clazz.getName() + ">");
        printStream.print(XmlEntity.encode(this.convert(this._instance)));
        printStream.print("</" + this._clazz.getName() + ">");
    }

    private String convert(Object object) {
        return object.toString();
    }

    public boolean shouldIndent() {
        return true;
    }
}

