/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model.nodes.field;

import com.db4o.objectmanager.model.IDatabase;
import com.db4o.objectmanager.model.nodes.IModelNode;
import com.db4o.objectmanager.model.nodes.field.FieldNode;
import com.db4o.objectmanager.model.nodes.field.FieldNodeFactory;
import com.db4o.objectmanager.model.nodes.partition.PartitionFieldNodeFactory;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import java.io.PrintStream;

public class ArrayFieldNode
extends FieldNode {
    private int length;
    private ReflectArray arrayReflector;

    public ArrayFieldNode(String string, ReflectClass reflectClass, Object object, IDatabase iDatabase) {
        super(string, reflectClass, object, iDatabase);
        this.arrayReflector = this._database.reflector().array();
        this.length = this.arrayReflector.getLength(this.value);
    }

    public IModelNode[] children() {
        IModelNode[] iModelNodeArray = new IModelNode[this.length];
        for (int i = 0; i < this.length; ++i) {
            Object object = this.arrayReflector.get(this.value, i);
            iModelNodeArray[i] = FieldNodeFactory.construct("[" + i + "] ", this._fieldType.getComponentType(), object, this._database);
        }
        return PartitionFieldNodeFactory.create(iModelNodeArray, 0, iModelNodeArray.length, this._database);
    }

    public boolean hasChildren() {
        return this.length > 0;
    }

    public String getText() {
        return this._fieldName + " " + this._database.reflector().forObject(this.value).getName();
    }

    public boolean isEditable() {
        return false;
    }

    public void printXmlValueNode(PrintStream printStream) {
        printStream.print("<" + this.getNodeName() + " id=\"" + this.getId() + "\">");
        printStream.print("</" + this.getNodeName() + ">");
    }

    public boolean shouldIndent() {
        return true;
    }
}

