/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.api.prefs;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.ObjectClass;
import com.db4o.objectmanager.api.prefs.ActivationPreferences;
import com.db4o.query.Query;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;

public class Preferences {
    private static Logger logger = Logger.getLogger(Preferences.class.getName());
    private static Preferences prefs = null;
    private static transient ObjectContainer db;
    private static final transient String preferencesFile;
    public static final String FRAME_SIZE = "frameSize";
    public static final String FRAME_LOCATION = "frameLocation";
    private HashMap preferenceStore = new HashMap();

    public static void initialize() {
    }

    public static Preferences getDefault() {
        if (prefs == null) {
            Preferences.loadOrCreatePreferences();
        }
        return prefs;
    }

    public void commit() {
        db.set((Object)prefs);
        db.commit();
    }

    public static void close() {
        if (db != null) {
            db.close();
        }
        db = null;
        prefs = null;
    }

    private static void loadOrCreatePreferences() {
        ObjectClass objectClass = Db4o.configure().objectClass(Preferences.class);
        objectClass.minimumActivationDepth(Integer.MAX_VALUE);
        objectClass.updateDepth(Integer.MAX_VALUE);
        Db4o.configure().allowVersionUpdates(true);
        db = Db4o.openFile((String)preferencesFile);
        Db4o.configure().allowVersionUpdates(false);
        Query query = db.query();
        query.constrain(Preferences.class);
        ObjectSet objectSet = query.execute();
        prefs = objectSet.hasNext() ? (Preferences)objectSet.next() : new Preferences();
        if (objectSet.size() > 1) {
            Preferences.rebuildCorruptDatabase(objectSet.size());
        }
        ActivationPreferences activationPreferences = (ActivationPreferences)prefs.getPreference("Activation");
    }

    private static void rebuildCorruptDatabase(int n) {
        logger.info(n + " instances of Preferences found in the database.");
        String string = preferencesFile + ".bkp";
        logger.info("Backing up database to " + string);
        try {
            db.ext().backup(string);
        }
        catch (RuntimeException runtimeException) {
            logger.info("Couldn't create backup file.");
            runtimeException.printStackTrace();
        }
        db.close();
        new File(preferencesFile).delete();
        db = Db4o.openFile((String)preferencesFile);
        db.set((Object)prefs);
        db.commit();
    }

    public void setPreference(String string, Object object) {
        long l = System.currentTimeMillis();
        this.preferenceStore.put(string, object);
        this.commit();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
    }

    public Object getPreference(String string) {
        return this.preferenceStore.get(string);
    }

    static {
        preferencesFile = new File(new File(System.getProperty("user.home")), ".objectmanager2.yap").getAbsolutePath();
    }
}

