/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import com.spaceprogram.db4o.sql.parser.Builder;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.parser.SqlParser;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.query.Where;
import com.spaceprogram.db4o.sql.query.WhereExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereBuilder
implements Builder {
    public static final String REGEX_OPERATORS = "<=|>=|<>|=|<|>";
    final String keyword = "WHERE";

    @Override
    public String getKeyword() {
        return "WHERE";
    }

    @Override
    public void build(SqlQuery sqlQuery, List<String> list, List<String> list2) throws SqlParseException {
        Where where = new Where();
        this.buildExpr(where.getRoot(), list, 0, list2);
        sqlQuery.setWhere(where);
    }

    private int buildExpr(WhereExpression whereExpression, List<String> list, int n, List<String> list2) throws SqlParseException {
        int n2;
        Pattern pattern = Pattern.compile(REGEX_OPERATORS);
        WhereExpression whereExpression2 = new WhereExpression();
        for (n2 = n; n2 < list.size(); ++n2) {
            Object object;
            Object object2;
            Object object3;
            String string = list.get(n2);
            if (string.startsWith("(")) {
                if (string.equals("(")) {
                    object3 = string;
                } else {
                    object3 = string.substring(1);
                    list.add(n2 + 1, (String)object3);
                }
                ++n2;
                object2 = new WhereExpression();
                whereExpression.add((WhereExpression)object2);
                n2 = this.buildExpr((WhereExpression)object2, list, n2, list2);
                continue;
            }
            if (string.equals(")")) {
                return n2;
            }
            if (string.equalsIgnoreCase("AND")) {
                whereExpression2 = new WhereExpression("AND");
                continue;
            }
            if (string.equalsIgnoreCase("OR")) {
                whereExpression2 = new WhereExpression("OR");
                continue;
            }
            object3 = pattern.matcher(string);
            object2 = this.findMatches((Matcher)object3);
            int n3 = object2.size();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n4 = 0;
            if (n3 > 1) {
                throw new SqlParseException("Too many operators in where expression: " + string);
            }
            if (n3 == 1) {
                object = (MatchResult)object2.get(0);
                string2 = object.group();
                string3 = string.substring(0, object.start());
                string4 = this.checkForNextPieceAttached(string, (MatchResult)object, string2);
            } else {
                string3 = string;
                if (list.size() <= n2 + 1) {
                    throw new SqlParseException("Invalid where expression.");
                }
                object = list.get(n2 + 1);
                Matcher matcher = pattern.matcher((CharSequence)object);
                List<MatchResult> list3 = this.findMatches(matcher);
                int n5 = list3.size();
                if (n5 > 1) {
                    throw new SqlParseException("Too many operators in where expression: " + string);
                }
                if (n5 == 1) {
                    MatchResult matchResult = list3.get(0);
                    string2 = matchResult.group();
                    if (((String)object).length() > matchResult.end()) {
                        string4 = ((String)object).substring(matchResult.end(), ((String)object).length());
                    }
                } else {
                    throw new SqlParseException("Operator not found in where expression.");
                }
                ++n4;
            }
            if (string4 == null) {
                string4 = list.get(n2 + n4 + 1);
                ++n4;
            }
            if (string4.endsWith(")")) {
                string4 = string4.substring(0, string4.length() - 1);
                list.add(n2 + n4 + 1, ")");
            }
            string4 = SqlParser.replaceQuotedValue(list2, string4);
            n2 += n4;
            if (string3 == null || string3.length() < 1 || string2 == null || string2.length() < 1 || string4 == null || string4.length() < 1) {
                throw new SqlParseException("Incomplete where expression.");
            }
            whereExpression2.setField(string3);
            whereExpression2.setOperator(string2);
            whereExpression2.setValue(string4);
            whereExpression.add(whereExpression2);
        }
        return n2;
    }

    private String checkForNextPieceAttached(String string, MatchResult matchResult, String string2) {
        String string3 = null;
        if (string.length() > matchResult.end() + string2.length()) {
            string3 = string.substring(matchResult.end(), string.length());
        }
        return string3;
    }

    private List<MatchResult> findMatches(Matcher matcher) {
        ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>();
        while (matcher.find()) {
            arrayList.add(matcher.toMatchResult());
        }
        return arrayList;
    }
}

