/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.internal.Platform4;
import com.db4o.io.IoAdapter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileAdapter
extends IoAdapter {
    private String _path;
    private RandomAccessFile _delegate;

    public RandomAccessFileAdapter() {
    }

    protected RandomAccessFileAdapter(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        boolean ok = false;
        try {
            this._path = new File(path).getCanonicalPath();
            this._delegate = new RandomAccessFile(this._path, readOnly ? "r" : "rw");
            if (initialLength > 0L) {
                this._delegate.seek(initialLength - 1L);
                this._delegate.write(new byte[]{0});
            }
            if (lockFile) {
                Platform4.lockFile(this._path, this._delegate);
            }
            ok = true;
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
    }

    public void close() throws Db4oIOException {
        try {
            if (this._delegate != null) {
                this._delegate.seek(0L);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Platform4.unlockFile(this._path, this._delegate);
        try {
            if (this._delegate != null) {
                this._delegate.close();
            }
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void delete(String path) {
        new File(path).delete();
    }

    public boolean exists(String path) {
        File existingFile = new File(path);
        return existingFile.exists() && existingFile.length() > 0L;
    }

    public long getLength() throws Db4oIOException {
        try {
            return this._delegate.length();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public IoAdapter open(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        return new RandomAccessFileAdapter(path, lockFile, initialLength, readOnly);
    }

    public int read(byte[] bytes, int length) throws Db4oIOException {
        try {
            return this._delegate.read(bytes, 0, length);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void seek(long pos) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.REGULAR_SEEK.log(pos);
        }
        try {
            this._delegate.seek(pos);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void sync() throws Db4oIOException {
        try {
            this._delegate.getFD().sync();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void write(byte[] buffer, int length) throws Db4oIOException {
        try {
            this._delegate.write(buffer, 0, length);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }
}

