/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.UnknownActivationDepth;
import com.db4o.internal.marshall.HandlerVersionContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectReferenceContext;

public class UnmarshallingContext
extends ObjectReferenceContext
implements HandlerVersionContext {
    private Object _object;
    private int _addToIDTree;
    private boolean _checkIDTree;

    public UnmarshallingContext(Transaction transaction, ByteArrayBuffer buffer, ObjectReference ref, int addToIDTree, boolean checkIDTree) {
        super(transaction, buffer, null, ref);
        this._addToIDTree = addToIDTree;
        this._checkIDTree = checkIDTree;
    }

    public UnmarshallingContext(Transaction transaction, ObjectReference ref, int addToIDTree, boolean checkIDTree) {
        this(transaction, null, ref, addToIDTree, checkIDTree);
    }

    public Object read() {
        return this.readInternal(false);
    }

    public Object readPrefetch() {
        return this.readInternal(true);
    }

    private final Object readInternal(boolean doAdjustActivationDepthForPrefetch) {
        Object objectInCacheFromClassCreation;
        if (!this.beginProcessing()) {
            return this._object;
        }
        this.readBuffer(this.objectID());
        if (this.buffer() == null) {
            this.endProcessing();
            return this._object;
        }
        ClassMetadata classMetadata = this.readObjectHeader();
        if (classMetadata == null) {
            this.endProcessing();
            return this._object;
        }
        this._reference.classMetadata(classMetadata);
        this.adjustActivationDepth(doAdjustActivationDepthForPrefetch);
        if (this._checkIDTree && (objectInCacheFromClassCreation = this.transaction().objectForIdFromCache(this.objectID())) != null) {
            this._object = objectInCacheFromClassCreation;
            this.endProcessing();
            return this._object;
        }
        this._object = this.peekPersisted() ? this.classMetadata().instantiateTransient(this) : this.classMetadata().instantiate(this);
        this.endProcessing();
        return this._object;
    }

    private void adjustActivationDepth(boolean doAdjustActivationDepthForPrefetch) {
        if (doAdjustActivationDepthForPrefetch) {
            this.adjustActivationDepthForPrefetch();
        } else if (UnknownActivationDepth.INSTANCE == this._activationDepth) {
            this._activationDepth = this.container().defaultActivationDepth(this.classMetadata());
        }
    }

    private void adjustActivationDepthForPrefetch() {
        this.activationDepth(this.activationDepthProvider().activationDepthFor(this.classMetadata(), ActivationMode.PREFETCH));
    }

    private ActivationDepthProvider activationDepthProvider() {
        return this.container().activationDepthProvider();
    }

    public Object readFieldValue(FieldMetadata field) {
        this.readBuffer(this.objectID());
        if (this.buffer() == null) {
            return null;
        }
        ClassMetadata classMetadata = this.readObjectHeader();
        if (classMetadata == null) {
            return null;
        }
        return this.readFieldValue(classMetadata, field);
    }

    private ClassMetadata readObjectHeader() {
        this._objectHeader = new ObjectHeader(this.container(), (ReadWriteBuffer)this.byteArrayBuffer());
        ClassMetadata classMetadata = this._objectHeader.classMetadata();
        if (classMetadata == null) {
            return null;
        }
        return classMetadata;
    }

    private void readBuffer(int id) {
        if (this.buffer() == null && id > 0) {
            this.buffer(this.container().readReaderByID(this.transaction(), id));
        }
    }

    private boolean beginProcessing() {
        return this._reference.beginProcessing();
    }

    private void endProcessing() {
        this._reference.endProcessing();
    }

    public void setStateClean() {
        this._reference.setStateClean();
    }

    public Object persistentObject() {
        return this._object;
    }

    public void setObjectWeak(Object obj) {
        this._reference.setObjectWeak(this.container(), obj);
    }

    protected boolean peekPersisted() {
        return this._addToIDTree == -1;
    }

    public Config4Class classConfig() {
        return this.classMetadata().config();
    }

    public void persistentObject(Object obj) {
        this._object = obj;
    }
}

