/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.net;

import com.db4o.internal.handlers.net.NetSimpleTypeHandler;
import com.db4o.reflect.Reflector;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class NetDateTime
extends NetSimpleTypeHandler {
    private static final String ZEROES = "0000";
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final long ERA_DIFFERENCE_IN_MS = 62135596800000L;
    private static final long TICKS_TO_MS_RATIO = 10000L;

    public NetDateTime(Reflector reflector) {
        super(reflector, 25, 8);
    }

    public String toString(byte[] bytes) {
        long ticks = 0L;
        for (int i = 0; i < 8; ++i) {
            ticks = (ticks << 8) + (long)(bytes[i] & 0xFF);
        }
        long ms = ticks / 10000L - 62135596800000L;
        Date date = new Date(ms);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        StringBuffer result = new StringBuffer().append(this.prependZeroes(cal.get(1), 4)).append('-').append(MONTHS[cal.get(2)]).append('-').append(this.prependZeroes(cal.get(5), 2)).append(", ").append(this.prependZeroes(cal.get(11), 2)).append(':').append(this.prependZeroes(cal.get(12), 2)).append(':').append(this.prependZeroes(cal.get(13), 2)).append('.').append(this.prependZeroes(cal.get(14), 3)).append(" UTC");
        return result.toString();
    }

    private String prependZeroes(int val, int size) {
        String str = String.valueOf(val);
        int missing = size - str.length();
        if (missing > 0) {
            str = ZEROES.substring(0, missing) + str;
        }
        return str;
    }
}

