/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.fieldindex.IndexedNode;
import com.db4o.internal.fieldindex.IndexedPath;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConObject;

public abstract class IndexedNodeBase
implements IndexedNode {
    private final QConObject _constraint;

    public IndexedNodeBase(QConObject qcon) {
        if (null == qcon) {
            throw new ArgumentNullException();
        }
        if (null == qcon.getField()) {
            throw new IllegalArgumentException();
        }
        this._constraint = qcon;
    }

    public TreeInt toTreeInt() {
        return IndexedNodeBase.addToTree(null, this);
    }

    public final BTree getIndex() {
        return this.getYapField().getIndex(this.transaction());
    }

    private FieldMetadata getYapField() {
        return this._constraint.getField().getYapField();
    }

    public QCon constraint() {
        return this._constraint;
    }

    public boolean isResolved() {
        QCon parent = this.constraint().parent();
        return null == parent || !parent.hasParent();
    }

    public BTreeRange search(Object value) {
        return this.getYapField().search(this.transaction(), value);
    }

    public static TreeInt addToTree(TreeInt tree, IndexedNode node) {
        Iterator4 i = node.iterator();
        while (i.moveNext()) {
            FieldIndexKey composite = (FieldIndexKey)i.current();
            tree = (TreeInt)Tree.add(tree, new TreeInt(composite.parentID()));
        }
        return tree;
    }

    public IndexedNode resolve() {
        if (this.isResolved()) {
            return null;
        }
        return IndexedPath.newParentPath(this, this.constraint());
    }

    private Transaction transaction() {
        return this.constraint().transaction();
    }
}

