/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.SimpleTimer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.TransportObjectContainer;

class WeakReferenceCollector
implements Runnable {
    final Object _queue;
    private final ObjectContainerBase _stream;
    private SimpleTimer _timer;
    public final boolean _weak;

    WeakReferenceCollector(ObjectContainerBase a_stream) {
        this._stream = a_stream;
        this._weak = !(a_stream instanceof TransportObjectContainer) && Platform4.hasWeakReferences() && a_stream.configImpl().weakReferences();
        this._queue = this._weak ? Platform4.createReferenceQueue() : null;
    }

    Object createYapRef(ObjectReference a_yo, Object obj) {
        if (!this._weak) {
            return obj;
        }
        return Platform4.createActiveObjectReference(this._queue, a_yo, obj);
    }

    void pollReferenceQueue() {
        if (!this._weak) {
            return;
        }
        Platform4.pollReferenceQueue(this._stream, this._queue);
    }

    public void run() {
        try {
            this.pollReferenceQueue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void startTimer() {
        if (!this._weak) {
            return;
        }
        if (!this._stream.configImpl().weakReferences()) {
            return;
        }
        if (this._stream.configImpl().weakReferenceCollectionInterval() <= 0) {
            return;
        }
        if (this._timer != null) {
            return;
        }
        this._timer = new SimpleTimer(this, this._stream.configImpl().weakReferenceCollectionInterval(), "db4o WeakReference collector");
        this._timer.start();
    }

    void stopTimer() {
        if (this._timer == null) {
            return;
        }
        this._timer.stop();
        this._timer = null;
    }
}

