/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.config.Configuration;
import com.db4o.config.FreespaceFiller;
import com.db4o.ext.BackupInProgressException;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.Cool;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Slot;
import com.db4o.io.IoAdapter;
import com.db4o.io.IoAdapterWindow;
import java.io.IOException;

public class IoAdaptedObjectContainer
extends LocalObjectContainer {
    private final String _fileName;
    private IoAdapter _file;
    private IoAdapter _timerFile;
    private volatile IoAdapter _backupFile;
    private Object _fileLock = new Object();
    private final FreespaceFiller _freespaceFiller;

    IoAdaptedObjectContainer(Configuration config, String fileName) throws OldFormatException {
        super(config, null);
        this._fileName = fileName;
        this._freespaceFiller = this.createFreespaceFiller();
        this.open();
    }

    protected final void openImpl() throws OldFormatException, DatabaseReadOnlyException {
        boolean isNew;
        IoAdapter ioAdapter = this.configImpl().io();
        boolean bl = isNew = !ioAdapter.exists(this.fileName());
        if (isNew) {
            this.logMsg(14, this.fileName());
            this.checkReadOnly();
            this._handlers.oldEncryptionOff();
        }
        boolean readOnly = this.configImpl().isReadOnly();
        boolean lockFile = this.configImpl().lockFile() && !readOnly;
        this._file = ioAdapter.open(this.fileName(), lockFile, 0L, readOnly);
        if (this.needsLockFileThread()) {
            this._timerFile = ioAdapter.delegatedIoAdapter().open(this.fileName(), false, 0L, false);
        }
        if (isNew) {
            this.configureNewFile();
            if (this.configImpl().reservedStorageSpace() > 0) {
                this.reserve(this.configImpl().reservedStorageSpace());
            }
            this.commitTransaction();
            this.writeHeader(true, false);
        } else {
            this.readThis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(IoAdapter targetIo, String path) throws DatabaseClosedException, Db4oIOException {
        Object object;
        Object object2 = this._lock;
        synchronized (object2) {
            this.checkClosed();
            if (this._backupFile != null) {
                throw new BackupInProgressException();
            }
            this._backupFile = targetIo.open(path, true, this._file.getLength(), false);
            this._backupFile.blockSize(this.blockSize());
        }
        long pos = 0L;
        byte[] buffer = new byte[8192];
        while (true) {
            object = this._lock;
            synchronized (object) {
                this._file.seek(pos);
                int read = this._file.read(buffer);
                if (read <= 0) {
                    break;
                }
                this._backupFile.seek(pos);
                this._backupFile.write(buffer, read);
                pos += (long)read;
            }
        }
        Cool.sleepIgnoringInterruption(1L);
        object = this._lock;
        synchronized (object) {
            this._backupFile.close();
            this._backupFile = null;
        }
    }

    public void blockSize(int size) {
        this._file.blockSize(size);
        if (this._timerFile != null) {
            this._timerFile.blockSize(size);
        }
    }

    public byte blockSize() {
        return (byte)this._file.blockSize();
    }

    protected void freeInternalResources() {
        this.freePrefetchedPointers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownDataStorage() {
        Object object = this._fileLock;
        synchronized (object) {
            this.closeDatabaseFile();
            this.closeFileHeader();
            this.closeTimerFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatabaseFile() {
        try {
            if (this._file != null) {
                this._file.close();
            }
        }
        finally {
            this._file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileHeader() {
        try {
            if (this._fileHeader != null) {
                this._fileHeader.close();
            }
        }
        finally {
            this._fileHeader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTimerFile() {
        try {
            if (this._timerFile != null) {
                this._timerFile.close();
            }
        }
        finally {
            this._timerFile = null;
        }
    }

    public void commit1(Transaction trans) {
        this.ensureLastSlotWritten();
        super.commit1(trans);
    }

    public void copy(int oldAddress, int oldAddressOffset, int newAddress, int newAddressOffset, int length) {
        try {
            if (this._backupFile == null) {
                this._file.blockCopy(oldAddress, oldAddressOffset, newAddress, newAddressOffset, length);
                return;
            }
            byte[] copyBytes = new byte[length];
            this._file.blockSeek(oldAddress, oldAddressOffset);
            this._file.read(copyBytes);
            this._file.blockSeek(newAddress, newAddressOffset);
            this._file.write(copyBytes);
            if (this._backupFile != null) {
                this._backupFile.blockSeek(newAddress, newAddressOffset);
                this._backupFile.write(copyBytes);
            }
        }
        catch (Exception e) {
            Exceptions4.throwRuntimeException(16, e);
        }
    }

    private void checkXBytes(int newAddress, int newAddressOffset, int length) {
    }

    public long fileLength() {
        try {
            return this._file.getLength();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public String fileName() {
        return this._fileName;
    }

    public void readBytes(byte[] bytes, int address, int length) throws Db4oIOException {
        this.readBytes(bytes, address, 0, length);
    }

    public void readBytes(byte[] bytes, int address, int addressOffset, int length) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.READ_BYTES.logLength(address + addressOffset, length);
        }
        this._file.blockSeek(address, addressOffset);
        int bytesRead = this._file.read(bytes, length);
        this.checkReadCount(bytesRead, length);
    }

    private void checkReadCount(int bytesRead, int expected) {
        if (bytesRead != expected) {
            throw new IncompatibleFileFormatException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(int byteCount) throws DatabaseReadOnlyException {
        this.checkReadOnly();
        Object object = this._lock;
        synchronized (object) {
            Slot slot = this.getSlot(byteCount);
            this.zeroReservedSlot(slot);
            this.free(slot);
        }
    }

    private void zeroReservedSlot(Slot slot) {
        this.zeroFile(this._file, slot);
        this.zeroFile(this._backupFile, slot);
    }

    private void zeroFile(IoAdapter io, Slot slot) {
        int left;
        if (io == null) {
            return;
        }
        byte[] zeroBytes = new byte[1024];
        io.blockSeek(slot.address(), 0);
        for (left = slot.length(); left > zeroBytes.length; left -= zeroBytes.length) {
            io.write(zeroBytes, zeroBytes.length);
        }
        if (left > 0) {
            io.write(zeroBytes, left);
        }
    }

    public void syncFiles() {
        this._file.sync();
        if (this._timerFile != null) {
            try {
                this._timerFile.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeBytes(ByteArrayBuffer buffer, int blockedAddress, int addressOffset) {
        if (DTrace.enabled) {
            DTrace.WRITE_BYTES.logLength(blockedAddress + addressOffset, buffer.length());
        }
        this._file.blockSeek(blockedAddress, addressOffset);
        this._file.write(buffer._buffer, buffer.length());
        if (this._backupFile != null) {
            this._backupFile.blockSeek(blockedAddress, addressOffset);
            this._backupFile.write(buffer._buffer, buffer.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteDeletedBytes(int address, int length) {
        if (this._freespaceFiller == null) {
            return;
        }
        if (address > 0 && length > 0) {
            if (DTrace.enabled) {
                DTrace.WRITE_XBYTES.logLength(address, length);
            }
            IoAdapterWindow window = new IoAdapterWindow(this._file, address, length);
            try {
                this.createFreespaceFiller().fill(window);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                window.disable();
            }
        }
    }

    public IoAdapter timerFile() {
        return this._timerFile;
    }

    private FreespaceFiller createFreespaceFiller() {
        FreespaceFiller freespaceFiller = this.config().freespaceFiller();
        return freespaceFiller;
    }

    private static class XByteFreespaceFiller
    implements FreespaceFiller {
        private XByteFreespaceFiller() {
        }

        public void fill(IoAdapterWindow io) throws IOException {
            io.write(0, this.xBytes(io.length()));
        }

        private byte[] xBytes(int len) {
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = 88;
            }
            return bytes;
        }
    }
}

