/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;

public class HashtableReferenceSystem
implements ReferenceSystem {
    private Hashtable4 _hashCodeTable = new Hashtable4();
    private Hashtable4 _idTable = new Hashtable4();

    public void addNewReference(ObjectReference ref) {
        this.addReference(ref);
    }

    public void addExistingReference(ObjectReference ref) {
        this.addReference(ref);
    }

    private void addReference(ObjectReference ref) {
        ref.ref_init();
        this.idAdd(ref);
        this.hashCodeAdd(ref);
    }

    public void commit() {
    }

    private void hashCodeAdd(ObjectReference ref) {
        this._hashCodeTable.put(HashtableReferenceSystem.hashCode(ref), (Object)ref);
    }

    private void idAdd(ObjectReference ref) {
        if (DTrace.enabled) {
            DTrace.ID_TREE_ADD.log(ref.getID());
        }
        this._idTable.put(ref.getID(), (Object)ref);
    }

    public ObjectReference referenceForId(int id) {
        if (DTrace.enabled) {
            DTrace.GET_YAPOBJECT.log(id);
        }
        if (!ObjectReference.isValidId(id)) {
            return null;
        }
        return (ObjectReference)this._idTable.get(id);
    }

    public ObjectReference referenceForObject(Object obj) {
        if (this._hashCodeTable == null) {
            return null;
        }
        return (ObjectReference)this._hashCodeTable.get(HashtableReferenceSystem.hashCode(obj));
    }

    private static final int hashCode(Object obj) {
        return ObjectReference.hc_getCode(obj);
    }

    private static final int hashCode(ObjectReference ref) {
        return ref._hcHashcode;
    }

    public void removeReference(ObjectReference ref) {
        if (DTrace.enabled) {
            DTrace.REFERENCE_REMOVED.log(ref.getID());
        }
        this._hashCodeTable.remove(HashtableReferenceSystem.hashCode(ref));
        this._idTable.remove(ref.getID());
    }

    public void rollback() {
    }

    public void traverseReferences(Visitor4 visitor) {
        Iterator4 i = this._hashCodeTable.values();
        while (i.moveNext()) {
            visitor.visit(i.current());
        }
    }
}

