/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.DTrace;
import com.db4o.ObjectSet;
import com.db4o.StaticClass;
import com.db4o.StaticField;
import com.db4o.TransactionAware;
import com.db4o.config.ConfigScope;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.ByReference;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.SubTypePredicate;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.EventDispatcher;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.IllegalComparisonException;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.ReadsObjectIds;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.TranslatedAspect;
import com.db4o.internal.TypeHandlerAspect;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.UnicodeStringIO;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.activation.ActivationContext4;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.fieldhandlers.FieldHandler;
import com.db4o.internal.handlers.FieldAwareTypeHandler;
import com.db4o.internal.handlers.FirstClassObjectHandler;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.handlers.NullFieldAwareTypeHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.marshall.AspectVersionContextImpl;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.ContextState;
import com.db4o.internal.marshall.HandlerVersionContext;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderContext;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.marshall.ObjectIdContextImpl;
import com.db4o.internal.marshall.ObjectReferenceContext;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.core.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.EmbeddedTypeHandler;
import com.db4o.typehandlers.FirstClassHandler;
import com.db4o.typehandlers.TypeHandler4;

public class ClassMetadata
extends PersistentBase
implements IndexableTypeHandler,
FirstClassHandler,
StoredClass,
FieldHandler,
ReadsObjectIds {
    private TypeHandler4 _typeHandler;
    public ClassMetadata i_ancestor;
    private Config4Class i_config;
    public ClassAspect[] _aspects;
    private final ClassIndexStrategy _index;
    protected String i_name;
    private final ObjectContainerBase _container;
    byte[] i_nameBytes;
    private ByteArrayBuffer i_reader;
    private boolean _classIndexed;
    private ReflectClass _classReflector;
    private boolean _isEnum;
    private EventDispatcher _eventDispatcher;
    private boolean _internal;
    private boolean _unversioned;
    private TernaryBool _canUpdateFast = TernaryBool.UNSPECIFIED;
    private TranslatedAspect _translator;

    public final ObjectContainerBase stream() {
        return this._container;
    }

    public final boolean canUpdateFast() {
        if (this._canUpdateFast == TernaryBool.UNSPECIFIED) {
            this._canUpdateFast = TernaryBool.forBoolean(this.checkCanUpdateFast());
        }
        return this._canUpdateFast.booleanValue(false);
    }

    private final boolean checkCanUpdateFast() {
        if (this.i_ancestor != null && !this.i_ancestor.canUpdateFast()) {
            return false;
        }
        if (this.i_config != null && this.i_config.cascadeOnDelete() == TernaryBool.YES) {
            return false;
        }
        final BooleanByRef hasIndex = new BooleanByRef(false);
        this.forEachDeclaredField(new Procedure4(){

            public void apply(Object arg) {
                if (((FieldMetadata)arg).hasIndex()) {
                    hasIndex.value = true;
                }
            }
        });
        return !hasIndex.value;
    }

    boolean isInternal() {
        return this._internal;
    }

    private ClassIndexStrategy createIndexStrategy() {
        return new BTreeClassIndexStrategy(this);
    }

    public ClassMetadata(ObjectContainerBase container, ReflectClass claxx) {
        this._typeHandler = this.createDefaultTypeHandler();
        this._container = container;
        this._classReflector = claxx;
        this._index = this.createIndexStrategy();
        this._classIndexed = true;
    }

    private FieldAwareTypeHandler createDefaultTypeHandler() {
        return new FirstClassObjectHandler(this);
    }

    public void activateFields(final Transaction trans, final Object obj, final ActivationDepth depth) {
        if (this.objectCanActivate(trans, obj)) {
            this.forEachAspect(new Procedure4(){

                public void apply(Object arg) {
                    ((ClassAspect)arg).cascadeActivation(trans, obj, depth);
                }
            });
        }
    }

    public final void addFieldIndices(StatefulBuffer buffer, Slot slot) {
        if (!this.firstClassObjectHandlerIsUsed()) {
            return;
        }
        if (this.hasClassIndex() || this.hasVirtualAttributes()) {
            ObjectHeader oh = new ObjectHeader(this._container, this, buffer);
            ObjectIdContextImpl context = new ObjectIdContextImpl(buffer.transaction(), buffer, oh, buffer.getID());
            this.fieldAwareTypeHandler(this.correctHandlerVersion(context)).addFieldIndices(context, slot);
        }
    }

    private boolean firstClassObjectHandlerIsUsed() {
        return this._typeHandler instanceof FirstClassObjectHandler;
    }

    void addMembers(ObjectContainerBase container) {
        DiagnosticProcessor dp;
        boolean defaultFieldBehaviour;
        this.bitTrue(6);
        Collection4 aspects = new Collection4();
        if (null != this._aspects) {
            aspects.addAll(this._aspects);
        }
        TypeHandler4 customTypeHandler = container.handlers().configuredTypeHandler(this.classReflector());
        boolean dirty = this.isDirty();
        if (this.installTranslator(aspects, customTypeHandler)) {
            dirty = true;
        }
        if (container.detectSchemaChanges()) {
            if (this.generateVersionNumbers() && !this.hasVersionField()) {
                aspects.add(container.versionIndex());
                dirty = true;
            }
            if (this.generateUUIDs() && !this.hasUUIDField()) {
                aspects.add(container.uUIDIndex());
                dirty = true;
            }
        }
        if (this.installCustomTypehandler(aspects, customTypeHandler)) {
            dirty = true;
        }
        boolean bl = defaultFieldBehaviour = this._translator == null && customTypeHandler == null;
        if (container.detectSchemaChanges()) {
            if (defaultFieldBehaviour) {
                dirty = this.collectReflectFields(container, aspects) | dirty;
            }
            if (dirty) {
                this._container.setDirtyInSystemTransaction(this);
            }
        }
        if (dirty || !defaultFieldBehaviour) {
            this._aspects = new ClassAspect[aspects.size()];
            aspects.toArray(this._aspects);
            for (int i = 0; i < this._aspects.length; ++i) {
                this._aspects[i].setHandle(i);
            }
        }
        if ((dp = this._container._handlers._diagnosticProcessor).enabled()) {
            dp.checkClassHasFields(this);
        }
        if (this._aspects == null) {
            this._aspects = new FieldMetadata[0];
        }
        this._container.callbacks().classOnRegistered(this);
        this.setStateOK();
    }

    private boolean installCustomTypehandler(Collection4 aspects, TypeHandler4 customTypeHandler) {
        if (customTypeHandler == null) {
            return false;
        }
        if (customTypeHandler instanceof EmbeddedTypeHandler) {
            this._typeHandler = customTypeHandler;
        }
        boolean dirty = false;
        TypeHandlerAspect typeHandlerAspect = new TypeHandlerAspect(customTypeHandler);
        if (!this.replaceAspectByName(aspects, typeHandlerAspect)) {
            aspects.add(typeHandlerAspect);
            dirty = true;
        }
        this.disableAspectsBefore(aspects, typeHandlerAspect);
        return dirty;
    }

    private void disableAspectsBefore(Collection4 aspects, TypeHandlerAspect typeHandlerAspect) {
        ClassAspect aspect;
        int disableFromVersion = aspects.indexOf(typeHandlerAspect) + 1;
        Iterator4 i = aspects.iterator();
        while (i.moveNext() && (aspect = (ClassAspect)i.current()) != typeHandlerAspect) {
            aspect.disableFromAspectCountVersion(disableFromVersion);
        }
    }

    private boolean installTranslator(Collection4 aspects, TypeHandler4 customTypeHandler) {
        if (this.i_config == null) {
            return false;
        }
        ObjectTranslator ot = this.i_config.getTranslator();
        if (ot == null) {
            return false;
        }
        TranslatedAspect translator = new TranslatedAspect(this, ot);
        if (this.replaceAspectByName(aspects, translator)) {
            this._translator = translator;
            return false;
        }
        if (customTypeHandler == null) {
            aspects.add(translator);
            this._translator = translator;
            return true;
        }
        return false;
    }

    private boolean replaceAspectByName(Collection4 aspects, ClassAspect aspect) {
        Iterator4 i = aspects.iterator();
        while (i.moveNext()) {
            ClassAspect current = (ClassAspect)i.current();
            if (!current.getName().equals(aspect.getName())) continue;
            aspects.replace(current, aspect);
            return true;
        }
        return false;
    }

    private boolean collectReflectFields(ObjectContainerBase container, Collection4 collectedAspects) {
        boolean dirty = false;
        ReflectField[] fields = this.reflectFields();
        for (int i = 0; i < fields.length; ++i) {
            ReflectClass fieldType;
            FieldHandler fieldHandler;
            if (!this.storeField(fields[i]) || (fieldHandler = container.fieldHandlerForClass(fieldType = Handlers4.baseType(fields[i].getFieldType()))) == null) continue;
            int fieldHandlerId = container.fieldHandlerIdForFieldHandler(fieldHandler);
            FieldMetadata field = new FieldMetadata(this, fields[i], (TypeHandler4)fieldHandler, fieldHandlerId);
            boolean found = false;
            Iterator4 aspectIterator = collectedAspects.iterator();
            while (aspectIterator.moveNext()) {
                if (!((ClassAspect)aspectIterator.current()).equals(field)) continue;
                found = true;
                break;
            }
            if (found) continue;
            dirty = true;
            collectedAspects.add(field);
        }
        return dirty;
    }

    void addToIndex(Transaction trans, int id) {
        if (!trans.container().maintainsIndices()) {
            return;
        }
        this.addToIndex1(trans, id);
    }

    final void addToIndex1(Transaction a_trans, int a_id) {
        if (this.i_ancestor != null) {
            this.i_ancestor.addToIndex1(a_trans, a_id);
        }
        if (this.hasClassIndex()) {
            this._index.add(a_trans, a_id);
        }
    }

    boolean allowsQueries() {
        return this.hasClassIndex();
    }

    public void cascadeActivation(ActivationContext4 context) {
        this.fieldAwareTypeHandler().cascadeActivation(context);
    }

    private FieldAwareTypeHandler fieldAwareTypeHandler() {
        if (this._typeHandler instanceof FieldAwareTypeHandler) {
            return (FieldAwareTypeHandler)this._typeHandler;
        }
        return NullFieldAwareTypeHandler.INSTANCE;
    }

    private FieldAwareTypeHandler fieldAwareTypeHandler(TypeHandler4 typeHandler) {
        if (typeHandler instanceof FieldAwareTypeHandler) {
            return (FieldAwareTypeHandler)typeHandler;
        }
        return NullFieldAwareTypeHandler.INSTANCE;
    }

    public boolean descendOnCascadingActivation() {
        return true;
    }

    void checkChanges() {
        if (this.stateOK() && !this.bitIsTrue(6)) {
            this.bitTrue(6);
            if (this.i_ancestor != null) {
                this.i_ancestor.checkChanges();
            }
            if (this._classReflector != null) {
                this.addMembers(this._container);
                Transaction trans = this._container.systemTransaction();
                if (!this._container.isClient() && !this.isReadOnlyContainer(trans)) {
                    this.write(trans);
                }
            }
        }
    }

    public void checkType() {
        ReflectClass claxx = this.classReflector();
        if (claxx == null) {
            return;
        }
        if (this._container._handlers.ICLASS_INTERNAL.isAssignableFrom(claxx)) {
            this._internal = true;
        }
        if (this._container._handlers.ICLASS_UNVERSIONED.isAssignableFrom(claxx)) {
            this._unversioned = true;
        }
        if (this.isDb4oTypeImpl()) {
            Db4oTypeImpl db4oTypeImpl = (Db4oTypeImpl)claxx.newInstance();
            this._classIndexed = db4oTypeImpl == null || db4oTypeImpl.hasClassIndex();
        } else if (this.i_config != null) {
            this._classIndexed = this.i_config.indexed();
        }
    }

    public boolean isDb4oTypeImpl() {
        return this._container._handlers.ICLASS_DB4OTYPEIMPL.isAssignableFrom(this.classReflector());
    }

    public final int adjustUpdateDepth(Transaction trans, int depth) {
        boolean cascadeOnUpdate;
        Config4Class config = this.configOrAncestorConfig();
        if (depth == -2147483548) {
            depth = this.checkUpdateDepthUnspecified(trans.container().configImpl());
            depth = this.adjustCollectionDepthToBorders(depth);
        }
        if (config == null) {
            return depth - 1;
        }
        boolean cascadeOnDelete = config.cascadeOnDelete() == TernaryBool.YES;
        boolean bl = cascadeOnUpdate = config.cascadeOnUpdate() == TernaryBool.YES;
        if (cascadeOnDelete || cascadeOnUpdate) {
            depth = this.adjustDepthToBorders(depth);
        }
        return depth - 1;
    }

    public int adjustCollectionDepthToBorders(int depth) {
        if (!this.classReflector().isCollection()) {
            return depth;
        }
        return this.adjustDepthToBorders(depth);
    }

    public int adjustDepthToBorders(int depth) {
        int depthBorder = this.reflector().collectionUpdateDepth(this.classReflector());
        if (depth > Integer.MIN_VALUE && depth < depthBorder) {
            depth = depthBorder;
        }
        return depth;
    }

    private final int checkUpdateDepthUnspecified(Config4Impl config) {
        int ancestordepth;
        int depth = config.updateDepth() + 1;
        if (this.i_config != null && this.i_config.updateDepth() != 0) {
            depth = this.i_config.updateDepth() + 1;
        }
        if (this.i_ancestor != null && (ancestordepth = this.i_ancestor.checkUpdateDepthUnspecified(config)) > depth) {
            return ancestordepth;
        }
        return depth;
    }

    public void collectConstraints(final Transaction trans, final QConObject parentConstraint, final Object obj, final Visitor4 visitor) {
        this.forEachField(new Procedure4(){

            public void apply(Object arg) {
                FieldMetadata fieldMetadata = (FieldMetadata)arg;
                if (fieldMetadata.enabled(AspectVersionContextImpl.CHECK_ALWAYS_ENABLED)) {
                    fieldMetadata.collectConstraints(trans, parentConstraint, obj, visitor);
                }
            }
        });
    }

    public final void collectIDs(CollectIdContext context, String fieldName) {
        if (!this.firstClassObjectHandlerIsUsed()) {
            throw new IllegalStateException();
        }
        ((FirstClassObjectHandler)this.correctHandlerVersion(context)).collectIDs(context, fieldName);
    }

    public void collectIDs(QueryingReadContext context) {
        if (!this.firstClassObjectHandlerIsUsed()) {
            throw new IllegalStateException();
        }
        TypeHandler4 typeHandler = this.correctHandlerVersion(context);
        if (typeHandler instanceof FirstClassHandler) {
            ((FirstClassHandler)typeHandler).collectIDs(context);
        }
    }

    public boolean customizedNewInstance() {
        return this.configInstantiates();
    }

    public Config4Class config() {
        return this.i_config;
    }

    public Config4Class configOrAncestorConfig() {
        if (this.i_config != null) {
            return this.i_config;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.configOrAncestorConfig();
        }
        return null;
    }

    private boolean createConstructor(ObjectContainerBase container, String className) {
        ReflectClass claxx = container.reflector().forName(className);
        return this.createConstructor(container, claxx, className, true);
    }

    public boolean createConstructor(ObjectContainerBase container, ReflectClass claxx, String name, boolean errMessages) {
        this.classReflector(claxx);
        this._eventDispatcher = EventDispatcher.forClass(container, claxx);
        if (claxx != null) {
            this._isEnum = Platform4.isEnum(this.reflector(), claxx);
        }
        if (this.customizedNewInstance()) {
            return true;
        }
        if (claxx != null && (container._handlers.ICLASS_TRANSIENTCLASS.isAssignableFrom(claxx) || Platform4.isTransient(claxx))) {
            claxx = null;
        }
        if (claxx == null) {
            if ((name == null || !Platform4.isDb4oClass(name)) && errMessages) {
                container.logMsg(23, name);
            }
            this.setStateDead();
            return false;
        }
        if (claxx.isAbstract() || claxx.isInterface()) {
            return true;
        }
        if (claxx.ensureCanBeInstantiated()) {
            return true;
        }
        this.setStateDead();
        if (errMessages) {
            container.logMsg(7, name);
        }
        if (container.configImpl().exceptionsOnNotStorable()) {
            throw new ObjectNotStorableException(claxx);
        }
        return false;
    }

    protected void classReflector(ReflectClass claxx) {
        this._classReflector = claxx;
        if (claxx == null) {
            this._typeHandler = null;
            return;
        }
        this._typeHandler = this.createDefaultTypeHandler();
    }

    public void deactivate(Transaction trans, Object obj, ActivationDepth depth) {
        if (this.objectCanDeactivate(trans, obj)) {
            this.deactivateFields(trans, obj, depth);
            this.objectOnDeactivate(trans, obj);
        }
    }

    private void objectOnDeactivate(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        container.callbacks().objectOnDeactivate(transaction, obj);
        this.dispatchEvent(transaction, obj, 3);
    }

    private boolean objectCanDeactivate(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        return container.callbacks().objectCanDeactivate(transaction, obj) && this.dispatchEvent(transaction, obj, 7);
    }

    final void deactivateFields(final Transaction trans, final Object obj, final ActivationDepth depth) {
        this.forEachAspect(new Procedure4(){

            public void apply(Object arg) {
                ClassAspect classAspect = (ClassAspect)arg;
                if (classAspect.enabled(AspectVersionContextImpl.CHECK_ALWAYS_ENABLED)) {
                    classAspect.deactivate(trans, obj, depth);
                }
            }
        });
    }

    final void delete(StatefulBuffer buffer, Object obj) {
        ObjectHeader oh = new ObjectHeader(this._container, this, buffer);
        Transaction trans = buffer.transaction();
        int id = buffer.getID();
        int typeId = trans.container()._handlers.arrayType(obj);
        this.removeFromIndex(trans, id);
        DeleteContextImpl context = new DeleteContextImpl(buffer, oh, this.classReflector(), null);
        this.deleteMembers(context, typeId, false);
    }

    public void delete(DeleteContext context) throws Db4oIOException {
        this.correctHandlerVersion(context).delete(context);
    }

    void deleteMembers(DeleteContextImpl context, int a_type, boolean isUpdate) {
        int preserveCascade;
        StatefulBuffer buffer;
        block5: {
            buffer = (StatefulBuffer)context.buffer();
            preserveCascade = context.cascadeDeleteDepth();
            try {
                if (this.cascadeOnDelete()) {
                    if (this.classReflector().isCollection()) {
                        buffer.setCascadeDeletes(this.collectionDeleteDepth(context));
                    } else {
                        buffer.setCascadeDeletes(1);
                    }
                }
                this.fieldAwareTypeHandler(this.correctHandlerVersion(context)).deleteMembers(context, isUpdate);
            }
            catch (Exception e) {
                DiagnosticProcessor dp = this.container()._handlers._diagnosticProcessor;
                if (!dp.enabled()) break block5;
                dp.deletionFailed();
            }
        }
        buffer.setCascadeDeletes(preserveCascade);
    }

    private int collectionDeleteDepth(DeleteContextImpl context) {
        int depth = context.cascadeDeleteDepth() + this.reflector().collectionUpdateDepth(this.classReflector()) - 3;
        if (depth < 1) {
            depth = 1;
        }
        return depth;
    }

    public TernaryBool cascadeOnDeleteTernary() {
        Config4Class config = this.config();
        TernaryBool cascadeOnDelete = TernaryBool.UNSPECIFIED;
        if (config != null && (cascadeOnDelete = config.cascadeOnDelete()) != TernaryBool.UNSPECIFIED) {
            return cascadeOnDelete;
        }
        if (this.i_ancestor == null) {
            return cascadeOnDelete;
        }
        return this.i_ancestor.cascadeOnDeleteTernary();
    }

    public boolean cascadeOnDelete() {
        return this.cascadeOnDeleteTernary() == TernaryBool.YES;
    }

    public final boolean dispatchEvent(Transaction trans, Object obj, int message) {
        if (!this.dispatchingEvents(trans)) {
            return true;
        }
        return this._eventDispatcher.dispatch(trans, obj, message);
    }

    private boolean dispatchingEvents(Transaction trans) {
        return this._eventDispatcher != null && trans.container().dispatchsEvents();
    }

    public final boolean hasEventRegistered(Transaction trans, int eventID) {
        if (!this.dispatchingEvents(trans)) {
            return false;
        }
        return this._eventDispatcher.hasEventRegistered(eventID);
    }

    public final int declaredAspectCount() {
        if (this._aspects == null) {
            return 0;
        }
        return this._aspects.length;
    }

    public final int aspectCount() {
        int count = this.declaredAspectCount();
        if (this.i_ancestor != null) {
            count += this.i_ancestor.aspectCount();
        }
        return count;
    }

    public final HandlerVersion seekToField(Transaction trans, ByteArrayBuffer buffer, FieldMetadata field) {
        if (buffer == null) {
            return HandlerVersion.INVALID;
        }
        if (!this.firstClassObjectHandlerIsUsed()) {
            return HandlerVersion.INVALID;
        }
        buffer.seek(0);
        ObjectHeader oh = new ObjectHeader(this._container, this, buffer);
        boolean res = this.seekToField(new ObjectHeaderContext(trans, buffer, oh), field);
        if (!res) {
            return HandlerVersion.INVALID;
        }
        return new HandlerVersion(oh.handlerVersion());
    }

    public final boolean seekToField(ObjectHeaderContext context, FieldMetadata field) {
        return this.fieldAwareTypeHandler(this.correctHandlerVersion(context)).seekToField(context, field);
    }

    public boolean generateUUIDs() {
        if (!this.generateVirtual()) {
            return false;
        }
        boolean configValue = this.i_config == null ? false : this.i_config.generateUUIDs();
        return this.generate1(this._container.config().generateUUIDs(), configValue);
    }

    private boolean generateVersionNumbers() {
        if (!this.generateVirtual()) {
            return false;
        }
        boolean configValue = this.i_config == null ? false : this.i_config.generateVersionNumbers();
        return this.generate1(this._container.config().generateVersionNumbers(), configValue);
    }

    private boolean generateVirtual() {
        if (this._unversioned) {
            return false;
        }
        return !this._internal;
    }

    private boolean generate1(ConfigScope globalConfig, boolean individualConfig) {
        return globalConfig.applyConfig(individualConfig);
    }

    public ClassMetadata getAncestor() {
        return this.i_ancestor;
    }

    public Object getComparableObject(Object forObject) {
        if (this.i_config != null && this.i_config.queryAttributeProvider() != null) {
            return this.i_config.queryAttributeProvider().attribute(forObject);
        }
        return forObject;
    }

    public ClassMetadata getHigherHierarchy(ClassMetadata a_yapClass) {
        ClassMetadata yc = this.getHigherHierarchy1(a_yapClass);
        if (yc != null) {
            return yc;
        }
        return a_yapClass.getHigherHierarchy1(this);
    }

    private ClassMetadata getHigherHierarchy1(ClassMetadata a_yapClass) {
        if (a_yapClass == this) {
            return this;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.getHigherHierarchy1(a_yapClass);
        }
        return null;
    }

    public ClassMetadata getHigherOrCommonHierarchy(ClassMetadata a_yapClass) {
        ClassMetadata yc = this.getHigherHierarchy1(a_yapClass);
        if (yc != null) {
            return yc;
        }
        if (this.i_ancestor != null && (yc = this.i_ancestor.getHigherOrCommonHierarchy(a_yapClass)) != null) {
            return yc;
        }
        return a_yapClass.getHigherHierarchy1(this);
    }

    public byte getIdentifier() {
        return 67;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIDs() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            return this.getIDs(this._container.transaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIDs(Transaction trans) {
        Object object = this.lock();
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            if (!this.hasClassIndex()) {
                return new long[0];
            }
            return trans.container().getIDsForClass(trans, this);
        }
    }

    public boolean hasClassIndex() {
        if (!this._classIndexed) {
            return false;
        }
        return this.firstClassObjectHandlerIsUsed() || !(this._typeHandler instanceof EmbeddedTypeHandler);
    }

    private boolean ancestorHasUUIDField() {
        if (this.i_ancestor == null) {
            return false;
        }
        return this.i_ancestor.hasUUIDField();
    }

    private boolean hasUUIDField() {
        if (this.ancestorHasUUIDField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this._aspects, UUIDFieldMetadata.class);
    }

    private boolean ancestorHasVersionField() {
        if (this.i_ancestor == null) {
            return false;
        }
        return this.i_ancestor.hasVersionField();
    }

    private boolean hasVersionField() {
        if (this.ancestorHasVersionField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this._aspects, VersionFieldMetadata.class);
    }

    public ClassIndexStrategy index() {
        return this._index;
    }

    public int indexEntryCount(Transaction ta) {
        if (!this.stateOK()) {
            return 0;
        }
        return this._index.entryCount(ta);
    }

    public final Object indexEntryToObject(Context context, Object indexEntry) {
        if (indexEntry == null) {
            return null;
        }
        int id = (Integer)indexEntry;
        return this.container().getByID2(context.transaction(), id);
    }

    public ReflectClass classReflector() {
        return this._classReflector;
    }

    public String getName() {
        if (this.i_name == null && this._classReflector != null) {
            this.i_name = this._classReflector.getName();
        }
        return this.i_name;
    }

    public StoredClass getParentStoredClass() {
        return this.getAncestor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredField[] getStoredFields() {
        Object object = this.lock();
        synchronized (object) {
            if (this._aspects == null) {
                return new StoredField[0];
            }
            StoredField[] fields = new StoredField[this._aspects.length];
            System.arraycopy(this._aspects, 0, fields, 0, this._aspects.length);
            return fields;
        }
    }

    final ObjectContainerBase container() {
        return this._container;
    }

    public FieldMetadata fieldMetadataForName(final String name) {
        final ByReference byReference = new ByReference();
        this.forEachField(new Procedure4(){

            public void apply(Object arg) {
                if (name.equals(((FieldMetadata)arg).getName())) {
                    byReference.value = arg;
                }
            }
        });
        return (FieldMetadata)byReference.value;
    }

    public boolean hasField(ObjectContainerBase container, String fieldName) {
        if (this.classReflector().isCollection()) {
            return true;
        }
        return this.fieldMetadataForName(fieldName) != null;
    }

    boolean hasVirtualAttributes() {
        if (this._internal) {
            return false;
        }
        return this.hasVersionField() || this.hasUUIDField();
    }

    public boolean holdsAnyClass() {
        return this.classReflector().isCollection();
    }

    void incrementFieldsOffset1(ByteArrayBuffer a_bytes) {
        int length = this.readAspectCount(a_bytes);
        for (int i = 0; i < length; ++i) {
            this._aspects[i].incrementOffset(a_bytes);
        }
    }

    final boolean init(ObjectContainerBase a_stream, ClassMetadata a_ancestor, ReflectClass claxx) {
        if (DTrace.enabled) {
            DTrace.CLASSMETADATA_INIT.log(this.getID());
        }
        this.setAncestor(a_ancestor);
        Config4Impl config = a_stream.configImpl();
        String className = claxx.getName();
        this.setConfig(config.configClass(className));
        if (!this.createConstructor(a_stream, claxx, className, false)) {
            return false;
        }
        this.checkType();
        if (this.allowsQueries()) {
            this._index.initialize(a_stream);
        }
        this.i_name = className;
        this.i_ancestor = a_ancestor;
        this.bitTrue(6);
        return true;
    }

    final void initConfigOnUp(Transaction systemTrans) {
        Config4Class extendedConfig = Platform4.extendConfiguration(this._classReflector, this._container.configure(), this.i_config);
        if (extendedConfig != null) {
            this.i_config = extendedConfig;
        }
        if (this.i_config == null) {
            return;
        }
        if (!this.stateOK()) {
            return;
        }
        if (this._aspects == null) {
            return;
        }
        for (int i = 0; i < this._aspects.length; ++i) {
            if (!(this._aspects[i] instanceof FieldMetadata)) continue;
            FieldMetadata field = (FieldMetadata)this._aspects[i];
            String fieldName = field.getName();
            if (!field.hasConfig() && extendedConfig != null && extendedConfig.configField(fieldName) != null) {
                field.initIndex(this, fieldName);
            }
            field.initConfigOnUp(systemTrans);
        }
    }

    void initOnUp(Transaction systemTrans) {
        if (!this.stateOK()) {
            return;
        }
        this.initConfigOnUp(systemTrans);
        this.storeStaticFieldValues(systemTrans, false);
    }

    public Object instantiate(UnmarshallingContext context) {
        boolean instantiating;
        Object obj = context.persistentObject();
        boolean bl = instantiating = obj == null;
        if (instantiating) {
            obj = this.instantiateObject(context);
            if (obj == null) {
                return null;
            }
            this.shareTransaction(obj, context.transaction());
            this.shareObjectReference(obj, context.objectReference());
            context.setObjectWeak(obj);
            context.transaction().referenceSystem().addExistingReference(context.objectReference());
            this.objectOnInstantiate(context.transaction(), obj);
            if (!context.activationDepth().requiresActivation()) {
                context.objectReference().setStateDeactivated();
            } else {
                obj = this.activate(context);
            }
        } else if (this.activatingActiveObject(context.activationDepth().mode(), context.objectReference())) {
            ActivationDepth child = context.activationDepth().descend(this);
            if (child.requiresActivation()) {
                this.activateFields(context.transaction(), obj, child);
            }
        } else {
            obj = this.activate(context);
        }
        return obj;
    }

    public Object instantiateTransient(UnmarshallingContext context) {
        Object obj = this.instantiateObject(context);
        if (obj == null) {
            return null;
        }
        context.container().peeked(context.objectID(), obj);
        if (context.activationDepth().requiresActivation()) {
            obj = this.instantiateFields(context);
        }
        return obj;
    }

    private boolean activatingActiveObject(ActivationMode mode, ObjectReference ref) {
        return !mode.isRefresh() && ref.isActive();
    }

    private Object activate(UnmarshallingContext context) {
        Object obj = context.persistentObject();
        if (!this.objectCanActivate(context.transaction(), obj)) {
            context.objectReference().setStateDeactivated();
            return obj;
        }
        context.objectReference().setStateClean();
        if (context.activationDepth().requiresActivation()) {
            obj = this.instantiateFields(context);
        }
        this.objectOnActivate(context.transaction(), obj);
        return obj;
    }

    private boolean configInstantiates() {
        return this.config() != null && this.config().instantiates();
    }

    private Object instantiateObject(UnmarshallingContext context) {
        Object obj = this.configInstantiates() ? this.instantiateFromConfig(context) : this.instantiateFromReflector(context.container());
        context.persistentObject(obj);
        return obj;
    }

    private void objectOnInstantiate(Transaction transaction, Object instance) {
        transaction.container().callbacks().objectOnInstantiate(transaction, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object instantiateFromReflector(ObjectContainerBase stream) {
        if (this._classReflector == null) {
            return null;
        }
        stream.instantiating(true);
        try {
            Object object = this._classReflector.newInstance();
            return object;
        }
        catch (NoSuchMethodError e) {
            stream.logMsg(7, this.classReflector().getName());
            Object var3_5 = null;
            return var3_5;
        }
        catch (Exception e) {
            Object var3_6 = null;
            return var3_6;
        }
        finally {
            stream.instantiating(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateFromConfig(ObjectReferenceContext context) {
        ContextState contextState = context.saveState();
        boolean fieldHasValue = this.seekToField(context, this._translator);
        try {
            Object object = this.i_config.instantiate(context.container(), fieldHasValue ? this._translator.read(context) : null);
            return object;
        }
        finally {
            context.restoreState(contextState);
        }
    }

    private void shareObjectReference(Object obj, ObjectReference ref) {
        if (obj instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)obj).setObjectReference(ref);
        }
    }

    private void shareTransaction(Object obj, Transaction transaction) {
        if (obj instanceof TransactionAware) {
            ((TransactionAware)obj).setTrans(transaction);
        }
    }

    private void objectOnActivate(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        container.callbacks().objectOnActivate(transaction, obj);
        this.dispatchEvent(transaction, obj, 2);
    }

    private boolean objectCanActivate(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        return container.callbacks().objectCanActivate(transaction, obj) && this.dispatchEvent(transaction, obj, 6);
    }

    Object instantiateFields(UnmarshallingContext context) {
        return this.read(context);
    }

    public boolean isArray() {
        return this.classReflector().isCollection();
    }

    public boolean isCollection() {
        return this.classReflector().isCollection();
    }

    boolean isCollection(Object obj) {
        return this.reflector().forObject(obj).isCollection();
    }

    public boolean isDirty() {
        if (!this.stateOK()) {
            return false;
        }
        return super.isDirty();
    }

    boolean isEnum() {
        return this._isEnum;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isStrongTyped() {
        return true;
    }

    public boolean isValueType() {
        return Platform4.isValueType(this.classReflector());
    }

    private final Object lock() {
        return this._container.lock();
    }

    public String nameToWrite() {
        if (this.i_config != null && this.i_config.writeAs() != null) {
            return this.i_config.writeAs();
        }
        if (this.i_name == null) {
            return "";
        }
        return this._container.configImpl().resolveAliasRuntimeName(this.i_name);
    }

    public final boolean callConstructor() {
        TernaryBool specialized = this.callConstructorSpecialized();
        if (!specialized.isUnspecified()) {
            return specialized.definiteYes();
        }
        return this._container.configImpl().callConstructors().definiteYes();
    }

    private final TernaryBool callConstructorSpecialized() {
        TernaryBool res;
        if (this.i_config != null && !(res = this.i_config.callConstructor()).isUnspecified()) {
            return res;
        }
        if (this._isEnum) {
            return TernaryBool.NO;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.callConstructorSpecialized();
        }
        return TernaryBool.UNSPECIFIED;
    }

    public int ownLength() {
        return MarshallerFamily.current()._class.marshalledLength(this._container, this);
    }

    public int prefetchActivationDepth() {
        return this.configOrAncestorConfig() == null ? 1 : 0;
    }

    void purge() {
        this._index.purge();
    }

    public Object readValueType(Transaction trans, int id, ActivationDepth depth) {
        ObjectReference ref = trans.referenceForId(id);
        if (ref != null) {
            Object obj = ref.getObject();
            if (obj == null) {
                trans.removeReference(ref);
            } else {
                ref.activate(trans, obj, depth);
                return ref.getObject();
            }
        }
        return new ObjectReference(id).read(trans, depth, 1, false);
    }

    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        TypeHandler4 typeHandler = this.correctHandlerVersion(context);
        if (typeHandler instanceof FirstClassHandler) {
            return ((FirstClassHandler)typeHandler).readCandidateHandler(context);
        }
        return null;
    }

    public TypeHandler4 seekCandidateHandler(QueryingReadContext context) {
        if (this.isArray()) {
            if (Platform4.isCollectionTranslator(this.i_config)) {
                context.seek(context.offset() + 4);
                return new ArrayHandler(null, false);
            }
            this.incrementFieldsOffset1((ByteArrayBuffer)context.buffer());
            if (this.i_ancestor != null) {
                return this.i_ancestor.seekCandidateHandler(context);
            }
        }
        return null;
    }

    public ObjectID readObjectID(InternalReadContext context) {
        return ObjectID.read(context);
    }

    public final int readAspectCount(ReadBuffer buffer) {
        int count = buffer.readInt();
        if (count > this._aspects.length) {
            return this._aspects.length;
        }
        return count;
    }

    public final Object readIndexEntry(ByteArrayBuffer a_reader) {
        return new Integer(a_reader.readInt());
    }

    public final Object readIndexEntryFromObjectSlot(MarshallerFamily mf, StatefulBuffer a_writer) throws CorruptionException {
        return this.readIndexEntry(a_writer);
    }

    public Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        return new Integer(context.readInt());
    }

    byte[] readName(Transaction a_trans) {
        this.i_reader = a_trans.container().readReaderByID(a_trans, this.getID());
        return this.readName1(a_trans, this.i_reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] readName1(Transaction trans, ByteArrayBuffer reader) {
        if (reader == null) {
            return null;
        }
        this.i_reader = reader;
        boolean ok = false;
        try {
            ClassMarshaller marshaller = MarshallerFamily.current()._class;
            this.i_nameBytes = marshaller.readName(trans, reader);
            marshaller.readMetaClassID(reader);
            this.setStateUnread();
            this.bitFalse(6);
            this.bitFalse(5);
            ok = true;
            byte[] byArray = this.i_nameBytes;
            return byArray;
        }
        finally {
            if (!ok) {
                this.setStateDead();
            }
        }
    }

    public void readVirtualAttributes(Transaction trans, ObjectReference ref, boolean lastCommitted) {
        int id = ref.getID();
        ObjectContainerBase stream = trans.container();
        ByteArrayBuffer buffer = stream.readReaderByID(trans, id, lastCommitted);
        ObjectHeader oh = new ObjectHeader(stream, this, buffer);
        ObjectReferenceContext context = new ObjectReferenceContext(trans, buffer, oh, ref);
        this.fieldAwareTypeHandler(this.correctHandlerVersion(context)).readVirtualAttributes(context);
    }

    public GenericReflector reflector() {
        return this._container.reflector();
    }

    public void rename(String newName) {
        if (!this._container.isClient()) {
            int tempState = this._state;
            this.setStateOK();
            this.i_name = newName;
            this.i_nameBytes = this.asBytes(this.i_name);
            this.setStateDirty();
            this.write(this._container.systemTransaction());
            ReflectClass oldReflector = this._classReflector;
            this.classReflector(this.container().reflector().forName(newName));
            this.container().classCollection().refreshClassCache(this, oldReflector);
            this.refresh();
            this._state = tempState;
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    private byte[] asBytes(String str) {
        return this.container().stringIO().write(str);
    }

    final void createConfigAndConstructor(Hashtable4 a_byteHashTable, ReflectClass claxx, String name) {
        this.i_name = name;
        this.setConfig(this._container.configImpl().configClass(this.i_name));
        if (claxx == null) {
            this.createConstructor(this._container, this.i_name);
        } else {
            this.createConstructor(this._container, claxx, this.i_name, true);
        }
        if (this.i_nameBytes != null) {
            a_byteHashTable.remove(this.i_nameBytes);
            this.i_nameBytes = null;
        }
    }

    String resolveName(ReflectClass claxx) {
        if (claxx != null) {
            return claxx.getName();
        }
        if (this.i_nameBytes != null) {
            String name = this._container.stringIO().read(this.i_nameBytes);
            return this._container.configImpl().resolveAliasStoredName(name);
        }
        throw new IllegalStateException();
    }

    boolean readThis() {
        boolean stateUnread = this.stateUnread();
        if (stateUnread) {
            this.setStateOK();
            this.setStateClean();
        }
        if (stateUnread || this.stateDead()) {
            this.forceRead();
            return true;
        }
        return false;
    }

    final void forceRead() {
        if (this.i_reader == null || this.bitIsTrue(8)) {
            return;
        }
        this.bitTrue(8);
        MarshallerFamily.forConverterVersion((int)this._container.converterVersion())._class.read(this._container, this, this.i_reader);
        this.i_nameBytes = null;
        this.i_reader = null;
        this.bitFalse(8);
    }

    public void readThis(Transaction a_trans, ByteArrayBuffer a_reader) {
        throw Exceptions4.virtualException();
    }

    public void refresh() {
        if (!this.stateUnread()) {
            this.createConstructor(this._container, this.i_name);
            this.bitFalse(6);
            this.checkChanges();
            this.forEachDeclaredField(new Procedure4(){

                public void apply(Object arg) {
                    ((FieldMetadata)arg).refresh();
                }
            });
        }
    }

    void removeFromIndex(Transaction ta, int id) {
        if (this.hasClassIndex()) {
            this._index.remove(ta, id);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.removeFromIndex(ta, id);
        }
    }

    boolean renameField(final String oldName, final String newName) {
        final BooleanByRef renamed = new BooleanByRef(false);
        for (int i = 0; i < this._aspects.length; ++i) {
            if (!this._aspects[i].getName().equals(newName)) continue;
            this._container.logMsg(9, "class:" + this.getName() + " field:" + newName);
            return false;
        }
        this.forEachDeclaredField(new Procedure4(){

            public void apply(Object arg) {
                FieldMetadata field = (FieldMetadata)arg;
                if (field.getName().equals(oldName)) {
                    field.setName(newName);
                    renamed.value = true;
                }
            }
        });
        return renamed.value;
    }

    void setConfig(Config4Class config) {
        if (config == null) {
            return;
        }
        if (this.i_config == null) {
            this.i_config = config;
        }
    }

    void setName(String a_name) {
        this.i_name = a_name;
    }

    final void setStateDead() {
        this.bitTrue(7);
        this.bitFalse(4);
    }

    private final void setStateUnread() {
        this.bitFalse(7);
        this.bitTrue(4);
    }

    final void setStateOK() {
        this.bitFalse(7);
        this.bitFalse(4);
    }

    boolean stateDead() {
        return this.bitIsTrue(7);
    }

    private final boolean stateOK() {
        return this.bitIsFalse(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    final boolean stateOKAndAncestors() {
        if (!this.stateOK() || this._aspects == null) {
            return false;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.stateOKAndAncestors();
        }
        return true;
    }

    boolean stateUnread() {
        return this.bitIsTrue(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    boolean storeField(ReflectField a_field) {
        if (a_field.isStatic()) {
            return false;
        }
        if (a_field.isTransient()) {
            Config4Class config = this.configOrAncestorConfig();
            if (config == null) {
                return false;
            }
            if (!config.storeTransientFields()) {
                return false;
            }
        }
        return Platform4.canSetAccessible() || a_field.isPublic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredField storedField(final String name, Object clazz) {
        Object object = this.lock();
        synchronized (object) {
            final ClassMetadata classMetadata = this._container.classMetadataForReflectClass(ReflectorUtils.reflectClassFor(this.reflector(), clazz));
            final ByReference foundField = new ByReference();
            this.forEachField(new Procedure4(){

                public void apply(Object arg) {
                    if (foundField.value != null) {
                        return;
                    }
                    FieldMetadata field = (FieldMetadata)arg;
                    if (field.getName().equals(name) && (classMetadata == null || classMetadata == field.handlerClassMetadata(ClassMetadata.this._container))) {
                        foundField.value = field;
                    }
                }
            });
            return (StoredField)foundField.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStaticFieldValues(Transaction trans, boolean force) {
        if (this.bitIsTrue(5) && !force) {
            return;
        }
        this.bitTrue(5);
        if (!this.shouldStoreStaticFields(trans)) {
            return;
        }
        ObjectContainerBase stream = trans.container();
        stream.showInternalClasses(true);
        try {
            StaticClass sc = this.queryStaticClass(trans);
            if (sc == null) {
                this.createStaticClass(trans);
            } else {
                this.updateStaticClass(trans, sc);
            }
        }
        finally {
            stream.showInternalClasses(false);
        }
    }

    private boolean shouldStoreStaticFields(Transaction trans) {
        return !this.isReadOnlyContainer(trans) && (this.staticFieldValuesArePersisted() || Platform4.storeStaticFieldValues(trans.reflector(), this.classReflector()));
    }

    private boolean isReadOnlyContainer(Transaction trans) {
        return trans.container().config().isReadOnly();
    }

    private void updateStaticClass(final Transaction trans, StaticClass sc) {
        ObjectContainerBase stream = trans.container();
        stream.activate(trans, sc, new FixedActivationDepth(4));
        final StaticField[] existingFields = sc.fields;
        Iterator4 staticFields = Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object arg) {
                ReflectField reflectField = (ReflectField)arg;
                StaticField existingField = ClassMetadata.this.fieldByName(existingFields, reflectField.getName());
                if (existingField != null) {
                    ClassMetadata.this.updateExistingStaticField(trans, existingField, reflectField);
                    return existingField;
                }
                return ClassMetadata.this.toStaticField(reflectField);
            }
        });
        sc.fields = this.toStaticFieldArray(staticFields);
        if (!stream.isClient()) {
            this.setStaticClass(trans, sc);
        }
    }

    private void createStaticClass(Transaction trans) {
        if (trans.container().isClient()) {
            return;
        }
        StaticClass sc = new StaticClass(this.i_name, this.toStaticFieldArray(this.staticReflectFieldsToStaticFields()));
        this.setStaticClass(trans, sc);
    }

    private Iterator4 staticReflectFieldsToStaticFields() {
        return Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object arg) {
                return ClassMetadata.this.toStaticField((ReflectField)arg);
            }
        });
    }

    protected StaticField toStaticField(ReflectField reflectField) {
        return new StaticField(reflectField.getName(), this.staticReflectFieldValue(reflectField));
    }

    private Object staticReflectFieldValue(ReflectField reflectField) {
        return reflectField.get(null);
    }

    private void setStaticClass(Transaction trans, StaticClass sc) {
        trans.container().storeInternal(trans, sc, true);
    }

    private StaticField[] toStaticFieldArray(Iterator4 iterator4) {
        return this.toStaticFieldArray(new Collection4(iterator4));
    }

    private StaticField[] toStaticFieldArray(Collection4 fields) {
        return (StaticField[])fields.toArray(new StaticField[fields.size()]);
    }

    private Iterator4 staticReflectFields() {
        return Iterators.filter(this.reflectFields(), new Predicate4(){

            public boolean match(Object candidate) {
                return ((ReflectField)candidate).isStatic();
            }
        });
    }

    private ReflectField[] reflectFields() {
        return this.classReflector().getDeclaredFields();
    }

    protected void updateExistingStaticField(Transaction trans, StaticField existingField, ReflectField reflectField) {
        int id;
        ObjectContainerBase stream = trans.container();
        Object newValue = this.staticReflectFieldValue(reflectField);
        if (existingField.value != null && newValue != null && existingField.value.getClass() == newValue.getClass() && (id = stream.getID(trans, existingField.value)) > 0) {
            if (existingField.value != newValue) {
                stream.bind(trans, newValue, id);
                stream.refresh(trans, newValue, Integer.MAX_VALUE);
                existingField.value = newValue;
            }
            return;
        }
        if (newValue == null) {
            try {
                reflectField.set(null, existingField.value);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        existingField.value = newValue;
    }

    private boolean staticFieldValuesArePersisted() {
        return this.i_config != null && this.i_config.staticFieldValuesArePersisted();
    }

    protected StaticField fieldByName(StaticField[] fields, String fieldName) {
        for (int i = 0; i < fields.length; ++i) {
            StaticField field = fields[i];
            if (!fieldName.equals(field.name)) continue;
            return field;
        }
        return null;
    }

    private StaticClass queryStaticClass(Transaction trans) {
        Query q = trans.container().query(trans);
        q.constrain(Const4.CLASS_STATICCLASS);
        q.descend("name").constrain(this.i_name);
        ObjectSet os = q.execute();
        return os.size() > 0 ? (StaticClass)os.next() : null;
    }

    public String toString() {
        if (this.i_name != null) {
            return this.i_name;
        }
        if (this.i_nameBytes == null) {
            return "*CLASS NAME UNKNOWN*";
        }
        UnicodeStringIO stringIO = this._container == null ? Const4.stringIO : this._container.stringIO();
        return ((LatinStringIO)stringIO).read(this.i_nameBytes);
    }

    public boolean writeObjectBegin() {
        if (!this.stateOK()) {
            return false;
        }
        return super.writeObjectBegin();
    }

    public void writeIndexEntry(ByteArrayBuffer a_writer, Object a_object) {
        if (a_object == null) {
            a_writer.writeInt(0);
            return;
        }
        a_writer.writeInt((Integer)a_object);
    }

    public final void writeThis(Transaction trans, ByteArrayBuffer writer) {
        MarshallerFamily.current()._class.write(trans, this, writer);
    }

    public PreparedComparison prepareComparison(Context context, Object source) {
        return this._typeHandler.prepareComparison(context, source);
    }

    public static void defragObject(DefragmentContextImpl context) {
        ObjectHeader header = ObjectHeader.defrag(context);
        DefragmentContextImpl childContext = new DefragmentContextImpl(context, header);
        header.classMetadata().defragment(childContext);
    }

    public void defragment(DefragmentContext context) {
        this.correctHandlerVersion(context).defragment(context);
    }

    public void defragClass(DefragmentContextImpl context, int classIndexID) {
        int converterVersion = this.container().converterVersion();
        MarshallerFamily mf = MarshallerFamily.forConverterVersion(converterVersion);
        mf._class.defrag(this, this._container.stringIO(), context, classIndexID);
    }

    public static ClassMetadata readClass(ObjectContainerBase stream, ByteArrayBuffer reader) {
        ObjectHeader oh = new ObjectHeader(stream, (ReadWriteBuffer)reader);
        return oh.classMetadata();
    }

    public boolean isAssignableFrom(ClassMetadata other) {
        return this.classReflector().isAssignableFrom(other.classReflector());
    }

    public final void defragIndexEntry(DefragmentContextImpl context) {
        context.copyID();
    }

    public void setAncestor(ClassMetadata ancestor) {
        if (ancestor == this) {
            throw new IllegalStateException();
        }
        this.i_ancestor = ancestor;
    }

    public Object wrapWithTransactionContext(Transaction transaction, Object value) {
        if (value instanceof Integer) {
            return value;
        }
        return new TransactionContext(transaction, value);
    }

    public Object read(ReadContext context) {
        return this.correctHandlerVersion((HandlerVersionContext)((Object)context)).read(context);
    }

    public void write(WriteContext context, Object obj) {
        this._typeHandler.write(context, obj);
    }

    public TypeHandler4 typeHandler() {
        return this;
    }

    protected boolean isSecondClass(TypeHandler4 handler) {
        return Handlers4.baseTypeHandler(handler) instanceof EmbeddedTypeHandler;
    }

    public TypeHandler4 delegateTypeHandler() {
        return this._typeHandler;
    }

    public boolean isSecondClass() {
        return this.isSecondClass(this._typeHandler);
    }

    private TypeHandler4 correctHandlerVersion(HandlerVersionContext context) {
        return Handlers4.correctHandlerVersion(context, this._typeHandler);
    }

    public void forEachField(Procedure4 procedure) {
        this.forEachAspect(new SubTypePredicate(FieldMetadata.class), procedure);
    }

    public void forEachDeclaredField(Procedure4 procedure) {
        this.forEachDeclaredAspect(new SubTypePredicate(FieldMetadata.class), procedure);
    }

    public void forEachAspect(Predicate4 predicate, Procedure4 procedure) {
        ClassMetadata classMetadata = this;
        while (classMetadata != null) {
            classMetadata.forEachDeclaredAspect(predicate, procedure);
            classMetadata = classMetadata.i_ancestor;
        }
    }

    public void forEachAspect(Procedure4 procedure) {
        ClassMetadata classMetadata = this;
        while (classMetadata != null) {
            classMetadata.forEachDeclaredAspect(procedure);
            classMetadata = classMetadata.i_ancestor;
        }
    }

    public void forEachDeclaredAspect(Predicate4 predicate, Procedure4 procedure) {
        if (this._aspects == null) {
            return;
        }
        for (int i = 0; i < this._aspects.length; ++i) {
            if (!predicate.match(this._aspects[i])) continue;
            procedure.apply(this._aspects[i]);
        }
    }

    public void forEachDeclaredAspect(Procedure4 procedure) {
        if (this._aspects == null) {
            return;
        }
        for (int i = 0; i < this._aspects.length; ++i) {
            procedure.apply(this._aspects[i]);
        }
    }

    public boolean aspectsAreNull() {
        return this._aspects == null;
    }

    public int instanceCount() {
        return this.instanceCount(this._container.transaction());
    }

    public int instanceCount(Transaction trans) {
        return this._container.instanceCount(this, trans);
    }

    public static final class PreparedComparisonImpl
    implements PreparedComparison {
        private final int _id;
        private final ReflectClass _claxx;

        public PreparedComparisonImpl(int id, ReflectClass claxx) {
            this._id = id;
            this._claxx = claxx;
        }

        public int compareTo(Object obj) {
            if (obj instanceof TransactionContext) {
                obj = ((TransactionContext)obj)._object;
            }
            if (obj == null) {
                return 1;
            }
            if (obj instanceof Integer) {
                int targetInt = (Integer)obj;
                return this._id == targetInt ? 0 : (this._id < targetInt ? -1 : 1);
            }
            if (this._claxx != null && this._claxx.isAssignableFrom(this._claxx.reflector().forObject(obj))) {
                return 0;
            }
            throw new IllegalComparisonException();
        }
    }
}

