/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.config.NativeSocketFactory;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Platform4;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class NetworkSocket
implements Socket4 {
    private Socket _socket;
    private OutputStream _out;
    private InputStream _in;
    private String _hostName;
    private NativeSocketFactory _factory;

    public NetworkSocket(NativeSocketFactory factory, String hostName, int port) throws Db4oIOException {
        this._factory = factory;
        try {
            Socket socket = this._factory.createSocket(hostName, port);
            this.initSocket(socket);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        this._hostName = hostName;
    }

    public NetworkSocket(NativeSocketFactory factory, Socket socket) throws IOException {
        this._factory = factory;
        this.initSocket(socket);
    }

    private void initSocket(Socket socket) throws IOException {
        this._socket = socket;
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
    }

    public void close() throws Db4oIOException {
        try {
            this._socket.close();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void flush() throws Db4oIOException {
        try {
            this._out.flush();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public boolean isConnected() {
        return Platform4.isConnected(this._socket);
    }

    public int read() throws Db4oIOException {
        try {
            int ret = this._in.read();
            this.checkEOF(ret);
            return ret;
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public int read(byte[] a_bytes, int a_offset, int a_length) throws Db4oIOException {
        try {
            int ret = this._in.read(a_bytes, a_offset, a_length);
            this.checkEOF(ret);
            return ret;
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    private void checkEOF(int ret) {
        if (ret == -1) {
            throw new Db4oIOException();
        }
    }

    public void setSoTimeout(int timeout) {
        try {
            this._socket.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void write(byte[] bytes) throws Db4oIOException {
        try {
            this._out.write(bytes);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void write(byte[] bytes, int off, int len) throws Db4oIOException {
        try {
            this._out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void write(int i) throws Db4oIOException {
        try {
            this._out.write(i);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public Socket4 openParalellSocket() throws Db4oIOException {
        if (this._hostName == null) {
            throw new IllegalStateException();
        }
        return new NetworkSocket(this._factory, this._hostName, this._socket.getPort());
    }
}

