/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.constraints;

import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.constraints.UniqueFieldValueConstraintViolationException;
import com.db4o.events.CommitEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistryFactory;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectInfoCollection;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.core.ReflectorUtils;

public class UniqueFieldValueConstraint
implements ConfigurationItem {
    protected final Object _clazz;
    protected final String _fieldName;

    public UniqueFieldValueConstraint(Object clazz, String fieldName) {
        this._clazz = clazz;
        this._fieldName = fieldName;
    }

    public void prepare(Configuration configuration) {
    }

    public void apply(final InternalObjectContainer objectContainer) {
        EventRegistryFactory.forObjectContainer(objectContainer).committing().addListener(new EventListener4(){
            private FieldMetadata _fieldMetaData;

            private void ensureSingleOccurence(Transaction trans, ObjectInfoCollection col) {
                Iterator4 i = col.iterator();
                while (i.moveNext()) {
                    BTreeRange range;
                    ObjectInfo info = (ObjectInfo)i.current();
                    int id = (int)info.getInternalID();
                    HardObjectReference ref = HardObjectReference.peekPersisted(trans, id, 1);
                    Object fieldValue = this.fieldMetadata().getOn(trans, ref._object);
                    if (fieldValue == null || (range = this.fieldMetadata().search(trans, fieldValue)).size() <= 1) continue;
                    throw new UniqueFieldValueConstraintViolationException(this.classMetadata().getName(), this.fieldMetadata().getName());
                }
            }

            private boolean isClassMetadataAvailable() {
                return null != this.classMetadata();
            }

            private FieldMetadata fieldMetadata() {
                if (this._fieldMetaData != null) {
                    return this._fieldMetaData;
                }
                this._fieldMetaData = this.classMetadata().fieldMetadataForName(UniqueFieldValueConstraint.this._fieldName);
                return this._fieldMetaData;
            }

            private ClassMetadata classMetadata() {
                return objectContainer.classMetadataForReflectClass(this.reflectClass());
            }

            private ReflectClass reflectClass() {
                return ReflectorUtils.reflectClassFor(objectContainer.reflector(), UniqueFieldValueConstraint.this._clazz);
            }

            public void onEvent(Event4 e, EventArgs args) {
                if (!this.isClassMetadataAvailable()) {
                    return;
                }
                CommitEventArgs commitEventArgs = (CommitEventArgs)args;
                Transaction trans = (Transaction)commitEventArgs.transaction();
                this.ensureSingleOccurence(trans, commitEventArgs.added());
                this.ensureSingleOccurence(trans, commitEventArgs.updated());
            }
        });
    }
}

