/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections.facades;

import com.db4o.collections.facades.CachedObject;
import com.db4o.collections.facades.FastListCache;
import com.db4o.foundation.Iterator4JdkIterator;
import com.db4o.foundation.JdkCollectionIterable4;
import com.db4o.internal.collections.PersistentList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastList
implements List {
    private PersistentList _persistentList;
    private transient FastListCache _cache;

    public FastList() {
    }

    public FastList(PersistentList persistentList) {
        this._persistentList = persistentList;
        this.ensureInitFastListCache();
    }

    private void ensureInitFastListCache() {
        if (this._cache == null) {
            this._cache = new FastListCache(this.size());
        }
    }

    public boolean add(Object o) {
        this.ensureInitFastListCache();
        this._cache.add(o);
        return this._persistentList.add(o);
    }

    public void add(int index, Object element) {
        this.validateIndex(index);
        this.ensureInitFastListCache();
        this._cache.add(index, element);
        this._persistentList.add(index, element);
    }

    public boolean addAll(Collection c) {
        this.ensureInitFastListCache();
        this._cache.addAll(c);
        return this._persistentList.addAll(new JdkCollectionIterable4(c));
    }

    public boolean addAll(int index, Collection c) {
        this.validateIndex(index);
        this.ensureInitFastListCache();
        this._cache.addAll(index, c);
        return this._persistentList.addAll(index, new JdkCollectionIterable4(c));
    }

    public void clear() {
        this.ensureInitFastListCache();
        this._cache.clear();
        this._persistentList.clear();
    }

    public boolean contains(Object o) {
        this.ensureInitFastListCache();
        if (this._cache.contains(o)) {
            return true;
        }
        return this._persistentList.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.ensureInitFastListCache();
        boolean ret = this._cache.containsAll(c);
        if (ret) {
            return true;
        }
        return this._persistentList.containsAll(new JdkCollectionIterable4(c));
    }

    public Object get(int index) {
        this.ensureInitFastListCache();
        CachedObject co = this._cache.get(index);
        if (co != CachedObject.NONE) {
            return co.obj;
        }
        return this._persistentList.get(index);
    }

    public int indexOf(Object o) {
        int index = this._cache.indexOf(o);
        if (index != -1) {
            return index;
        }
        return this._persistentList.indexOf(o);
    }

    public boolean isEmpty() {
        return this._persistentList.isEmpty();
    }

    public Iterator iterator() {
        return new Iterator4JdkIterator(this._persistentList.iterator());
    }

    public int lastIndexOf(Object o) {
        return this._persistentList.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        this.ensureInitFastListCache();
        this._cache.remove(o);
        return this._persistentList.remove(o);
    }

    public Object remove(int index) {
        this.ensureInitFastListCache();
        this._cache.remove(index);
        return this._persistentList.remove(index);
    }

    public boolean removeAll(Collection c) {
        this.ensureInitFastListCache();
        this._cache.removeAll(c);
        return this._persistentList.removeAll(new JdkCollectionIterable4(c));
    }

    public boolean retainAll(Collection c) {
        this.ensureInitFastListCache();
        this._cache.retainAll(c);
        return this._persistentList.retainAll(new JdkCollectionIterable4(c));
    }

    public Object set(int index, Object element) {
        this.validateIndex(index);
        this.ensureInitFastListCache();
        this._cache.set(index, element);
        return this._persistentList.set(index, element);
    }

    public int size() {
        return this._persistentList.size();
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        return this._persistentList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._persistentList.toArray(a);
    }

    private void validateIndex(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

