/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.collections.SubArrayList4;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList4<E>
implements Iterable<E>,
Collection<E>,
List<E> {
    protected transient int modCount;

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<E> cIter = collection.iterator();
        while (cIter.hasNext()) {
            this.add(cIter.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<E> cIter = collection.iterator();
        int pos = index;
        while (cIter.hasNext()) {
            this.add(pos++, cIter.next());
        }
        return true;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        if (otherList.size() != this.size()) {
            return false;
        }
        Iterator<E> iter = this.iterator();
        Iterator otherIter = otherList.iterator();
        while (iter.hasNext()) {
            E e1 = iter.next();
            Object e2 = otherIter.next();
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayList4Iterator(-1);
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<E> iter = this.listIterator();
        while (iter.hasNext()) {
            if (!this.equals(o, iter.next())) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator<E> iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (!this.equals(o, iter.previous())) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    private boolean equals(Object e1, E e2) {
        return e1 == null ? e2 == null : e1.equals(e2);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.checkIndex(index, 0, this.size());
        return new ArrayList4IndexIterator(index);
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= this.size() || toIndex > this.size() || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        ListIterator<E> iter = this.listIterator(fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract int size();

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubArrayList4(this, fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] data = new Object[size];
        Iterator<E> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            data[i++] = iter.next();
        }
        return data;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<E> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            a[i++] = iter.next();
        }
        return a;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E element = iter.next();
            if (element != this) {
                buffer.append(element);
            } else {
                buffer.append("(this Collection)");
            }
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    void checkIndex(int index, int from, int to) {
        if (index < from || index > to) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArrayList4IndexIterator
    extends ArrayList4Iterator
    implements ListIterator<E> {
        public ArrayList4IndexIterator(int index) {
            super(index - 1);
        }

        @Override
        public void add(E element) {
            this.checkCanOperate();
            this.checkConcurrentModification();
            try {
                AbstractList4.this.add(this.currentIndex, element);
                ++this.currentIndex;
                this.syncModCount();
                this.setCanOperateFlag(false);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex != -1;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex + 1;
        }

        @Override
        public E previous() {
            this.checkConcurrentModification();
            try {
                Object element = AbstractList4.this.get(this.currentIndex);
                --this.currentIndex;
                this.setCanOperateFlag(true);
                return element;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.currentIndex;
        }

        @Override
        public void set(E element) {
            this.checkCanOperate();
            this.checkConcurrentModification();
            try {
                AbstractList4.this.set(this.currentIndex, element);
                this.setCanOperateFlag(false);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArrayList4Iterator
    implements Iterator<E> {
        protected int currentIndex;
        private int _iteratorModCount;
        protected boolean canOperate;

        public ArrayList4Iterator(int pos) {
            this.currentIndex = pos;
            this.syncModCount();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex + 1 < AbstractList4.this.size();
        }

        @Override
        public E next() {
            this.checkConcurrentModification();
            try {
                Object element = AbstractList4.this.get(this.currentIndex + 1);
                ++this.currentIndex;
                this.setCanOperateFlag(true);
                return element;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            this.checkCanOperate();
            this.checkConcurrentModification();
            AbstractList4.this.remove(this.currentIndex);
            --this.currentIndex;
            this.syncModCount();
            this.setCanOperateFlag(false);
        }

        protected void syncModCount() {
            this._iteratorModCount = AbstractList4.this.modCount;
        }

        protected void checkCanOperate() {
            if (!this.canOperate) {
                throw new IllegalStateException();
            }
        }

        protected void setCanOperateFlag(boolean enabled) {
            this.canOperate = enabled;
        }

        protected void checkConcurrentModification() {
            if (this._iteratorModCount != AbstractList4.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

