/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.Configuration;
import com.db4o.config.NativeSocketFactory;
import com.db4o.config.PlainSocketFactory;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.InvalidPasswordException;
import com.db4o.ext.MemoryFile;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.network.NetworkSocket;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.InMemoryObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerFactory;
import com.db4o.internal.Platform4;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.reflect.Reflector;

public class Db4o {
    static final Config4Impl i_config = new Config4Impl();

    public static void main(String[] args) {
        System.out.println(Db4o.version());
    }

    public static Configuration configure() {
        return i_config;
    }

    public static Configuration newConfiguration() {
        Config4Impl config = new Config4Impl();
        Platform4.getDefaultConfiguration(config);
        return config;
    }

    public static Configuration cloneConfiguration() {
        return (Config4Impl)((DeepClone)((Object)Db4o.configure())).deepClone(null);
    }

    public static ObjectContainer openClient(String hostName, int port, String user, String password) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        return Db4o.openClient(Db4o.cloneConfiguration(), hostName, port, user, password);
    }

    public static ObjectContainer openClient(Configuration config, String hostName, int port, String user, String password) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        return Db4o.openClient(config, hostName, port, user, password, new PlainSocketFactory());
    }

    public static ObjectContainer openClient(Configuration config, String hostName, int port, String user, String password, NativeSocketFactory socketFactory) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        if (user == null || password == null) {
            throw new InvalidPasswordException();
        }
        NetworkSocket networkSocket = new NetworkSocket(socketFactory, hostName, port);
        return new ClientObjectContainer(config, networkSocket, user, password, true);
    }

    public static final ObjectContainer openFile(String databaseFileName) throws Db4oIOException, DatabaseFileLockedException, IncompatibleFileFormatException, OldFormatException, DatabaseReadOnlyException {
        return Db4o.openFile(Db4o.cloneConfiguration(), databaseFileName);
    }

    public static final ObjectContainer openFile(Configuration config, String databaseFileName) throws Db4oIOException, DatabaseFileLockedException, IncompatibleFileFormatException, OldFormatException, DatabaseReadOnlyException {
        return ObjectContainerFactory.openObjectContainer(config, databaseFileName);
    }

    protected static final ObjectContainer openMemoryFile1(Configuration config, MemoryFile memoryFile) throws Db4oIOException, DatabaseFileLockedException, OldFormatException {
        if (memoryFile == null) {
            memoryFile = new MemoryFile();
        }
        InMemoryObjectContainer oc = new InMemoryObjectContainer(config, memoryFile);
        Messages.logMsg(config, 5, "Memory File");
        return oc;
    }

    public static final ObjectServer openServer(String databaseFileName, int port) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        return Db4o.openServer(Db4o.cloneConfiguration(), databaseFileName, port);
    }

    public static final ObjectServer openServer(Configuration config, String databaseFileName, int port) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        return Db4o.openServer(config, databaseFileName, port, new PlainSocketFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ObjectServer openServer(Configuration config, String databaseFileName, int port, NativeSocketFactory socketFactory) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        LocalObjectContainer stream = (LocalObjectContainer)Db4o.openFile(config, databaseFileName);
        if (stream == null) {
            return null;
        }
        Object object = stream.lock();
        synchronized (object) {
            return new ObjectServerImpl(stream, port, socketFactory);
        }
    }

    static Reflector reflector() {
        return i_config.reflector();
    }

    public static final String version() {
        return "db4o 7.4.106.13438";
    }

    static {
        Platform4.getDefaultConfiguration(i_config);
    }
}

