/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.query;

import com.db4o.ObjectContainer;
import com.db4o.objectManager.v2.TabType;
import com.db4o.objectManager.v2.UISession;
import com.db4o.objectManager.v2.custom.FastScrollPane;
import com.db4o.objectManager.v2.query.DateEditor;
import com.db4o.objectManager.v2.query.QueryResultsTableModel;
import com.db4o.objectManager.v2.query.QueryResultsTableSelectionListener;
import com.db4o.objectManager.v2.results.DateRenderer;
import com.db4o.objectManager.v2.tree.ObjectTree;
import com.db4o.objectManager.v2.tree.ObjectTreeCellEditor;
import com.db4o.objectManager.v2.tree.ObjectTreeModel;
import com.db4o.objectManager.v2.tree.ObjectTreeNode;
import com.db4o.objectManager.v2.uif_lite.panel.SimpleInternalFrame;
import com.db4o.objectmanager.model.IGraphIterator;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;

public class QueryResultsPanel
extends JPanel {
    private JTable resultsTable;
    private TableModel tableModel;
    private SimpleInternalFrame resultsFrame;
    private JLabel statusLabel = new JLabel();
    private UISession session;

    public QueryResultsPanel(UISession session) {
        super(new BorderLayout());
        this.session = session;
        this.setOpaque(false);
        this.setBorder(Borders.DIALOG_BORDER);
        this.add(this.buildTablePanel());
        this.add((Component)this.buildStatusBar(), "South");
    }

    private JPanel buildStatusBar() {
        JPanel p = new JPanel();
        p.add(this.statusLabel);
        return p;
    }

    private JComponent buildTablePanel() {
        JScrollPane table = this.buildResultsTable();
        this.resultsFrame = new SimpleInternalFrame("Results");
        this.resultsFrame.setPreferredSize(new Dimension(300, 100));
        this.resultsFrame.add(table);
        return this.resultsFrame;
    }

    private JScrollPane buildResultsTable() {
        this.resultsTable = new JTable();
        this.resultsTable.setAutoResizeMode(0);
        this.resultsTable.setDefaultRenderer(Date.class, new DateRenderer());
        JTextField tf = new JTextField();
        this.resultsTable.setDefaultEditor(Date.class, new DateEditor(tf));
        FastScrollPane scrollpane = new FastScrollPane(this.resultsTable);
        scrollpane.setHorizontalScrollBarPolicy(32);
        scrollpane.setVerticalScrollBarPolicy(22);
        QueryResultsTableSelectionListener listener = new QueryResultsTableSelectionListener(this.resultsTable, this);
        this.resultsTable.addMouseListener(listener);
        return scrollpane;
    }

    public void displayResults(String query) {
        try {
            this.tableModel = new QueryResultsTableModel(query, this);
            this.resultsTable.setModel(this.tableModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.resultsTable.getColumnCount() > 0) {
            TableColumn column = this.resultsTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(20);
            for (int i = 1; i < this.resultsTable.getColumnCount(); ++i) {
                column = this.resultsTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(100);
            }
        }
    }

    public void addObjectToBatch(Object o) {
        this.session.getObjectContainer().set(o);
        this.session.getObjectContainer().commit();
    }

    public ObjectContainer getObjectContainer() {
        return this.session.getObjectContainer();
    }

    public void setStatusMessage(String msg) {
        this.statusLabel.setForeground(Color.BLACK);
        this.statusLabel.setText(msg);
    }

    public void setErrorMessage(String s) {
        this.statusLabel.setForeground(Color.RED);
        this.statusLabel.setText(s);
    }

    public void showObjectTree(Object o) {
        ObjectTreeNode top = new ObjectTreeNode(null, null, o);
        ObjectTreeModel objectTreeModel = new ObjectTreeModel(top, this.session);
        ObjectTree tree = new ObjectTree(objectTreeModel);
        tree.setEditable(true);
        JTextField tf = new JTextField();
        DefaultTreeCellEditor editor = new DefaultTreeCellEditor(tree, (DefaultTreeCellRenderer)tree.getCellRenderer(), new ObjectTreeCellEditor(tf));
        tree.setCellEditor(editor);
        JScrollPane treeView = new JScrollPane(tree);
        this.session.addTab(TabType.objectTree, "Object: " + o, treeView);
    }

    private void createNodes(DefaultMutableTreeNode top, IGraphIterator iter) {
        while (iter.hasNext()) {
            DefaultMutableTreeNode node;
            if (iter.nextHasChildren()) {
                node = new DefaultMutableTreeNode(iter.selectNextChild());
                top.add(node);
                continue;
            }
            node = new DefaultMutableTreeNode(iter.next());
            top.add(node);
        }
        if (iter.hasParent()) {
            iter.selectParent();
            this.createNodes(new DefaultMutableTreeNode(iter.next()), iter);
        }
    }
}

