/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.query;

import com.db4o.objectManager.v2.MainPanel;
import com.db4o.objectManager.v2.query.QueryHistoryComboBoxModel;
import com.db4o.objectManager.v2.query.QueryHistoryRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class QueryBarPanel
extends JPanel {
    private JTextArea queryText;
    private JLabel queryStatus;
    private JComboBox queryList;
    static final String LAST_QUERY = "lastQuery";
    private static final String QUERY_HISTORY = "queryHistory";
    private MainPanel mainPanel;
    private List queryHistory;

    public QueryBarPanel(MainPanel mainPanel2) {
        super(new BorderLayout());
        this.mainPanel = mainPanel2;
        this.setBorder(new EmptyBorder(10, 10, 2, 10));
        this.add((Component)new JLabel("Query:"), "West");
        this.queryHistory = (List)this.mainPanel.getPreferenceForDatabase(QUERY_HISTORY);
        QueryHistoryComboBoxModel queryListModel = new QueryHistoryComboBoxModel(this.queryHistory);
        this.queryList = new JComboBox(queryListModel);
        this.queryList.setRenderer(new QueryHistoryRenderer());
        this.queryList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                if (cb.getSelectedIndex() > 0) {
                    String queryString = (String)cb.getSelectedItem();
                    QueryBarPanel.this.queryText.setText(queryString);
                }
            }
        });
        this.add((Component)this.queryList, "North");
        this.queryText = new JTextArea(5, 0);
        JScrollPane scrollPane = new JScrollPane(this.queryText);
        String lastQuery = (String)this.mainPanel.getPreferenceForDatabase(LAST_QUERY);
        if (lastQuery != null) {
            this.queryText.setText(lastQuery);
        }
        this.add((Component)scrollPane, "Center");
        JButton submit = new JButton("  Submit  ");
        submit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String query = QueryBarPanel.this.queryText.getText();
                if (query.length() > 0) {
                    QueryBarPanel.this.addToQueryHistory(query);
                    QueryBarPanel.this.mainPanel.displayResults(query);
                }
            }
        });
        this.add(new JPanel().add(submit), "East");
        this.queryStatus = new JLabel();
        this.add((Component)this.queryStatus, "South");
    }

    private void addToQueryHistory(String query) {
        this.mainPanel.setPreferenceForDatabase(LAST_QUERY, query);
        ArrayList<String> x = this.queryHistory;
        if (x == null) {
            x = new ArrayList<String>();
        }
        int exists = -1;
        for (int i = 0; i < x.size(); ++i) {
            String s = (String)x.get(i);
            if (!s.equalsIgnoreCase(query)) continue;
            exists = i;
            break;
        }
        if (exists == -1) {
            x.add(0, query);
        } else {
            String s = (String)x.remove(exists);
            x.add(0, s);
        }
        this.mainPanel.setPreferenceForDatabase(QUERY_HISTORY, x);
    }

    private void setErrorMessage(String message) {
        this.queryStatus.setForeground(Color.RED);
        this.queryStatus.setText(message);
    }

    private void setStatusMessage(String message) {
        this.queryStatus.setForeground(Color.BLACK);
        this.queryStatus.setText(message);
    }

    public JTextArea getQueryText() {
        return this.queryText;
    }

    public void showClassSummary(String className) {
        this.mainPanel.showClassSummary(className);
    }
}

