/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.configuration;

import com.db4o.objectManager.v2.configuration.ConfigurationPanel;
import com.db4o.objectManager.v2.custom.BackgroundPanel;
import com.db4o.objectManager.v2.resources.ResourceManager;
import com.db4o.objectmanager.configuration.ConfigurationFacade;
import com.jgoodies.looks.Options;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ConfigurationDialog
extends JDialog {
    private final String TITLE = "Configuration";
    private ConfigurationPanel configurationPanel = null;
    private BackgroundPanel mainPanel;
    private ConfigurationFacade configuration;

    public ConfigurationDialog(ConfigurationFacade configuration) {
        this.configuration = configuration;
        this.initialize();
        this.setModal(true);
    }

    private void initialize() {
        this.configureUI();
        this.setSize(new Dimension(484, 289));
        this.setContentPane(this.getConfigurationPanel());
        this.setIconImage(ResourceManager.createImageIcon("icons/plain/16x16/configure.png", "configure").getImage());
        this.setTitle("Configuration");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
            }
        });
    }

    private void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        String lafName = Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
    }

    private JPanel getConfigurationPanel() {
        if (this.configurationPanel == null) {
            this.mainPanel = new BackgroundPanel();
            this.configurationPanel = new ConfigurationPanel(this, this.configuration);
            this.mainPanel.add(this.configurationPanel.buildPanel());
        }
        return this.mainPanel;
    }

    public ConfigurationFacade getConfiguration() {
        return this.configurationPanel.configuration();
    }
}

