/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.objectManager.v2.query.QueryBarPanel;
import com.db4o.objectManager.v2.query.QueryBuilder;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ClassTreeListener
extends MouseAdapter {
    private JTextArea queryText;
    private QueryBarPanel queryBarPanel;

    public ClassTreeListener(QueryBarPanel queryBarPanel) {
        this.queryBarPanel = queryBarPanel;
        this.queryText = queryBarPanel.getQueryText();
    }

    public void mousePressed(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        int selRow = tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (node == null) {
                return;
            }
            if (e.getClickCount() != 1 && e.getClickCount() == 2) {
                String nodeInfo = (String)node.getUserObject();
                if (!node.isLeaf() && !node.isRoot()) {
                    this.queryText.setText(QueryBuilder.addClass(this.queryText.getText(), nodeInfo));
                    this.queryBarPanel.showClassSummary(nodeInfo);
                } else {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    String nodeObject = (String)parent.getUserObject();
                    this.queryText.setText(QueryBuilder.addField(this.queryText.getText(), nodeObject, nodeInfo));
                }
            }
        }
    }
}

