/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2;

import com.db4o.objectManager.v2.Settings;
import com.db4o.objectManager.v2.resources.ResourceManager;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class BaseMenuBar
extends JMenuBar {
    public BaseMenuBar(Settings settings, ActionListener helpActionListener, ActionListener aboutActionListener) {
        this.putClientProperty("jgoodies.headerStyle", settings.getMenuBarHeaderStyle());
        this.putClientProperty("Plastic.borderStyle", settings.getMenuBarPlasticBorderStyle());
        this.putClientProperty("jgoodies.windows.borderStyle", settings.getMenuBarWindowsBorderStyle());
        this.putClientProperty("Plastic.is3D", settings.getMenuBar3DHint());
    }

    protected JMenu buildHelpMenu(ActionListener helpActionListener, ActionListener aboutActionListener) {
        JMenu menu = this.createMenu("Help", 'H');
        JMenuItem item = this.createMenuItem("Help Contents", ResourceManager.createImageIcon("help.gif"), 'H');
        if (helpActionListener != null) {
            item.addActionListener(helpActionListener);
        }
        menu.add(item);
        menu.addSeparator();
        item = this.createMenuItem("About", 'a');
        item.addActionListener(aboutActionListener);
        menu.add(item);
        return menu;
    }

    protected JMenu createMenu(String text, char mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    protected JMenuItem createMenuItem(String text) {
        return new JMenuItem(text);
    }

    protected JMenuItem createMenuItem(String text, char mnemonic) {
        return new JMenuItem(text, mnemonic);
    }

    protected JMenuItem createMenuItem(String text, char mnemonic, KeyStroke key) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.setAccelerator(key);
        return menuItem;
    }

    protected JMenuItem createMenuItem(String text, Icon icon) {
        return new JMenuItem(text, icon);
    }

    protected JMenuItem createMenuItem(String text, Icon icon, char mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, icon);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    protected JMenuItem createMenuItem(String text, Icon icon, char mnemonic, KeyStroke key) {
        JMenuItem menuItem = this.createMenuItem(text, icon, mnemonic);
        menuItem.setAccelerator(key);
        return menuItem;
    }
}

