/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.DTrace;
import com.db4o.config.Compare;
import com.db4o.config.ObjectAttribute;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.No4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.Null;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConClass;
import com.db4o.internal.query.processor.QConEvaluation;
import com.db4o.internal.query.processor.QEContains;
import com.db4o.internal.query.processor.QEEndsWith;
import com.db4o.internal.query.processor.QEEqual;
import com.db4o.internal.query.processor.QEGreater;
import com.db4o.internal.query.processor.QEIdentity;
import com.db4o.internal.query.processor.QENot;
import com.db4o.internal.query.processor.QESmaller;
import com.db4o.internal.query.processor.QEStartsWith;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.query.processor.QOrder;
import com.db4o.marshall.Context;
import com.db4o.query.Constraint;
import com.db4o.reflect.ReflectClass;

public class QConObject
extends QCon {
    public Object i_object;
    public int i_objectID;
    transient ClassMetadata i_yapClass;
    public int i_yapClassID;
    public QField i_field;
    transient PreparedComparison _preparedComparison;
    public ObjectAttribute i_attributeProvider;
    private transient boolean i_selfComparison = false;

    public QConObject() {
    }

    public QConObject(Transaction a_trans, QCon a_parent, QField a_field, Object a_object) {
        super(a_trans);
        this.i_parent = a_parent;
        if (a_object instanceof Compare) {
            a_object = ((Compare)a_object).compare();
        }
        this.i_object = a_object;
        this.i_field = a_field;
    }

    private void associateYapClass(Transaction a_trans, Object a_object) {
        if (a_object != null) {
            this.i_yapClass = a_trans.container().produceClassMetadata(a_trans.reflector().forObject(a_object));
            if (this.i_yapClass != null) {
                this.i_object = this.i_yapClass.getComparableObject(a_object);
                if (a_object != this.i_object) {
                    this.i_attributeProvider = this.i_yapClass.config().queryAttributeProvider();
                    this.i_yapClass = a_trans.container().produceClassMetadata(a_trans.reflector().forObject(this.i_object));
                }
                if (this.i_yapClass != null) {
                    this.i_yapClass.collectConstraints(a_trans, this, this.i_object, new Visitor4(){

                        public void visit(Object obj) {
                            QConObject.this.addConstraint((QCon)obj);
                        }
                    });
                } else {
                    this.associateYapClass(a_trans, null);
                }
            } else {
                this.associateYapClass(a_trans, null);
            }
        }
    }

    public boolean canBeIndexLeaf() {
        return this.i_yapClass != null && this.i_yapClass.isPrimitive() || this.evaluator().identity();
    }

    public boolean canLoadByIndex() {
        if (this.i_field == null) {
            return false;
        }
        if (this.i_field.i_yapField == null) {
            return false;
        }
        if (!this.i_field.i_yapField.hasIndex()) {
            return false;
        }
        if (!this.i_evaluator.supportsIndex()) {
            return false;
        }
        return this.i_field.i_yapField.canLoadByIndex();
    }

    boolean evaluate(QCandidate a_candidate) {
        try {
            return a_candidate.evaluate(this, this.i_evaluator);
        }
        catch (Exception e) {
            return false;
        }
    }

    void evaluateEvaluationsExec(QCandidates a_candidates, boolean rereadObject) {
        if (this.i_field.isSimple()) {
            boolean hasEvaluation = false;
            Iterator4 i = this.iterateChildren();
            while (i.moveNext()) {
                if (!(i.current() instanceof QConEvaluation)) continue;
                hasEvaluation = true;
                break;
            }
            if (hasEvaluation) {
                a_candidates.traverse(this.i_field);
                Iterator4 j = this.iterateChildren();
                while (j.moveNext()) {
                    ((QCon)j.current()).evaluateEvaluationsExec(a_candidates, false);
                }
            }
        }
    }

    void evaluateSelf() {
        if (DTrace.enabled) {
            DTrace.EVALUATE_SELF.log(this.i_id);
        }
        if (this.i_yapClass != null && !(this.i_yapClass instanceof PrimitiveFieldHandler)) {
            if (!this.i_evaluator.identity()) {
                this.i_selfComparison = true;
            }
            Object transactionalObject = this.i_yapClass.wrapWithTransactionContext(this.transaction(), this.i_object);
            this._preparedComparison = this.i_yapClass.prepareComparison(this.context(), transactionalObject);
        }
        super.evaluateSelf();
        this.i_selfComparison = false;
    }

    private Context context() {
        return this.transaction().context();
    }

    void collect(QCandidates a_candidates) {
        if (this.i_field.isClass()) {
            a_candidates.traverse(this.i_field);
            a_candidates.filter(this.i_candidates);
        }
    }

    void evaluateSimpleExec(QCandidates a_candidates) {
        if (this.i_field.isSimple() || this.isNullConstraint()) {
            a_candidates.traverse(this.i_field);
            this.prepareComparison(this.i_field);
            a_candidates.filter(this);
        }
    }

    PreparedComparison prepareComparison(QCandidate candidate) {
        if (this._preparedComparison != null) {
            return this._preparedComparison;
        }
        return candidate.prepareComparison(this.container(), this.i_object);
    }

    ClassMetadata getYapClass() {
        return this.i_yapClass;
    }

    public QField getField() {
        return this.i_field;
    }

    int getObjectID() {
        if (this.i_objectID == 0) {
            this.i_objectID = this.i_trans.container().getID(this.i_trans, this.i_object);
            if (this.i_objectID == 0) {
                this.i_objectID = -1;
            }
        }
        return this.i_objectID;
    }

    public boolean hasObjectInParentPath(Object obj) {
        if (obj == this.i_object) {
            return true;
        }
        return super.hasObjectInParentPath(obj);
    }

    public int identityID() {
        int id;
        if (this.i_evaluator.identity() && (id = this.getObjectID()) != 0 && !(this.i_evaluator instanceof QENot)) {
            return id;
        }
        return 0;
    }

    boolean isNullConstraint() {
        return this.i_object == null;
    }

    void log(String indent) {
    }

    String logObject() {
        return "";
    }

    void marshall() {
        super.marshall();
        this.getObjectID();
        if (this.i_yapClass != null) {
            this.i_yapClassID = this.i_yapClass.getID();
        }
    }

    public boolean onSameFieldAs(QCon other) {
        if (!(other instanceof QConObject)) {
            return false;
        }
        return this.i_field == ((QConObject)other).i_field;
    }

    void prepareComparison(QField a_field) {
        this._preparedComparison = this.isNullConstraint() & !a_field.isArray() ? Null.INSTANCE : a_field.prepareComparison(this.context(), this.i_object);
    }

    void removeChildrenJoins() {
        super.removeChildrenJoins();
        this._children = null;
    }

    QCon shareParent(Object a_object, boolean[] removeExisting) {
        if (this.i_parent == null) {
            return null;
        }
        Object obj = this.i_field.coerce(a_object);
        if (obj == No4.INSTANCE) {
            return null;
        }
        return this.i_parent.addSharedConstraint(this.i_field, obj);
    }

    QConClass shareParentForClass(ReflectClass a_class, boolean[] removeExisting) {
        if (this.i_parent == null) {
            return null;
        }
        if (!this.i_field.canHold(a_class)) {
            return null;
        }
        QConClass newConstraint = new QConClass(this.i_trans, this.i_parent, this.i_field, a_class);
        this.i_parent.addConstraint(newConstraint);
        return newConstraint;
    }

    final Object translate(Object candidate) {
        if (this.i_attributeProvider != null) {
            this.i_candidates.i_trans.container().activate(this.i_candidates.i_trans, candidate);
            return this.i_attributeProvider.attribute(candidate);
        }
        return candidate;
    }

    void unmarshall(Transaction trans) {
        if (this.i_trans == null) {
            Object obj;
            super.unmarshall(trans);
            if (this.i_object == null) {
                this._preparedComparison = Null.INSTANCE;
            }
            if (this.i_yapClassID != 0) {
                this.i_yapClass = trans.container().classMetadataForId(this.i_yapClassID);
            }
            if (this.i_field != null) {
                this.i_field.unmarshall(trans);
            }
            if (this.i_objectID > 0 && (obj = trans.container().getByID(trans, this.i_objectID)) != null) {
                this.i_object = obj;
            }
        }
    }

    public void visit(Object obj) {
        Object cmp;
        ClassMetadata yc;
        QCandidate qc = (QCandidate)obj;
        boolean res = true;
        boolean processed = false;
        if (this.i_selfComparison && (yc = qc.readYapClass()) != null) {
            res = this.i_evaluator.not(this.i_yapClass.getHigherHierarchy(yc) == this.i_yapClass);
            processed = true;
        }
        if (!processed) {
            res = this.evaluate(qc);
        }
        if (this.hasOrdering() && res && qc.fieldIsAvailable() && (cmp = qc.value()) != null && this.i_field != null) {
            PreparedComparison preparedComparisonBackup = this._preparedComparison;
            this._preparedComparison = this.i_field.prepareComparison(this.context(), qc.value());
            this.i_candidates.addOrder(new QOrder(this, qc));
            this._preparedComparison = preparedComparisonBackup;
        }
        this.visit1(qc.getRoot(), this, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint contains() {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QEContains(true));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint equal() {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QEEqual());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.streamLock();
        synchronized (object) {
            return this.i_object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint greater() {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QEGreater());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint identity() {
        Object object = this.streamLock();
        synchronized (object) {
            if (this.i_object == null) {
                return this;
            }
            int id = this.getObjectID();
            if (id <= 0) {
                this.i_objectID = 0;
                Exceptions4.throwRuntimeException(51);
            }
            this.removeChildrenJoins();
            this.i_evaluator = this.i_evaluator.add(new QEIdentity());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint byExample() {
        Object object = this.streamLock();
        synchronized (object) {
            this.associateYapClass(this.i_trans, this.i_object);
            return this;
        }
    }

    void setEvaluationMode() {
        if (this.i_object == null || this.evaluationModeAlreadySet()) {
            return;
        }
        int id = this.getObjectID();
        if (id < 0) {
            this.byExample();
        } else {
            this.i_yapClass = this.i_trans.container().produceClassMetadata(this.i_trans.reflector().forObject(this.i_object));
            this.identity();
        }
    }

    boolean evaluationModeAlreadySet() {
        return this.i_yapClass != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint like() {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QEContains(false));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint smaller() {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QESmaller());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint startsWith(boolean caseSensitive) {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QEStartsWith(caseSensitive));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint endsWith(boolean caseSensitive) {
        Object object = this.streamLock();
        synchronized (object) {
            this.i_evaluator = this.i_evaluator.add(new QEEndsWith(caseSensitive));
            return this;
        }
    }

    public String toString() {
        String str = "QConObject ";
        if (this.i_object != null) {
            str = str + this.i_object.toString();
        }
        return str;
    }
}

