/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.ext.Db4oException;
import com.db4o.foundation.IntArrayList;
import com.db4o.internal.query.processor.Orderable;

class Order
implements Orderable {
    private int i_major;
    private IntArrayList i_minors = new IntArrayList();

    Order() {
    }

    public int compareTo(Object obj) {
        if (obj instanceof Order) {
            Order other = (Order)obj;
            int res = this.i_major - other.i_major;
            if (res != 0) {
                return res;
            }
            return this.compareMinors(other.i_minors);
        }
        return -1;
    }

    public void hintOrder(int a_order, boolean a_major) {
        if (a_major) {
            this.i_major = a_order;
        } else {
            this.appendMinor(a_order);
        }
    }

    public boolean hasDuplicates() {
        return true;
    }

    public String toString() {
        String str = "Order " + this.i_major;
        for (int i = 0; i < this.i_minors.size(); ++i) {
            str = str + " " + this.i_minors.get(i);
        }
        return str;
    }

    public void swapMajorToMinor() {
        this.insertMinor(this.i_major);
        this.i_major = 0;
    }

    private void appendMinor(int minor) {
        this.i_minors.add(minor);
    }

    private void insertMinor(int minor) {
        this.i_minors.add(0, minor);
    }

    private int compareMinors(IntArrayList other) {
        if (this.i_minors.size() != other.size()) {
            throw new Db4oException("Unexpected exception: this..size()=" + this.i_minors.size() + ", other.size()=" + other.size());
        }
        int result = 0;
        for (int i = 0; i < this.i_minors.size(); ++i) {
            if (this.i_minors.get(i) == other.get(i)) continue;
            return this.i_minors.get(i) - other.get(i);
        }
        return result;
    }
}

