/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.array;

import com.db4o.foundation.BitMap4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.MultidimensionalArrayIterator;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.ReservedBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ArrayInfo;
import com.db4o.reflect.MultidimensionalArrayInfo;
import com.db4o.reflect.ReflectArray;
import com.db4o.typehandlers.TypeHandler4;

public class MultidimensionalArrayHandler
extends ArrayHandler {
    public MultidimensionalArrayHandler(TypeHandler4 a_handler, boolean a_isPrimitive) {
        super(a_handler, a_isPrimitive);
    }

    public MultidimensionalArrayHandler() {
    }

    public final Iterator4 allElements(ObjectContainerBase container, Object array) {
        return MultidimensionalArrayHandler.allElements(this.arrayReflector(container), array);
    }

    public static Iterator4 allElements(ReflectArray reflectArray, Object array) {
        return new MultidimensionalArrayIterator(reflectArray, (Object[])array);
    }

    protected static final int elementCount(int[] a_dim) {
        int elements = a_dim[0];
        for (int i = 1; i < a_dim.length; ++i) {
            elements *= a_dim[i];
        }
        return elements;
    }

    public final byte identifier() {
        return 90;
    }

    protected ArrayInfo newArrayInfo() {
        return new MultidimensionalArrayInfo();
    }

    protected void readDimensions(ArrayInfo info, ReadBuffer buffer) {
        this.readDimensions(info, buffer, buffer.readInt());
    }

    private void readDimensions(ArrayInfo info, ReadBuffer buffer, int dimensionCount) {
        int[] dim = new int[dimensionCount];
        for (int i = 0; i < dim.length; ++i) {
            dim[i] = buffer.readInt();
        }
        ((MultidimensionalArrayInfo)info).dimensions(dim);
        info.elementCount(MultidimensionalArrayHandler.elementCount(dim));
    }

    protected void detectDimensionsPreVersion0Format(ReadBuffer buffer, ArrayInfo info, int classID) {
        this.readDimensions(info, buffer, classID);
    }

    protected void readElements(ReadContext context, ArrayInfo info, Object array) {
        if (array == null) {
            return;
        }
        Object[] objects = new Object[info.elementCount()];
        this.readInto(context, info, objects);
        this.arrayReflector(this.container(context)).shape(objects, 0, array, ((MultidimensionalArrayInfo)info).dimensions(), 0);
    }

    protected void writeDimensions(WriteContext context, ArrayInfo info) {
        int[] dim = ((MultidimensionalArrayInfo)info).dimensions();
        context.writeInt(dim.length);
        for (int i = 0; i < dim.length; ++i) {
            context.writeInt(dim[i]);
        }
    }

    protected void writeElements(WriteContext context, Object obj, ArrayInfo info) {
        Iterator4 objects = this.allElements(this.container(context), obj);
        if (this.hasNullBitmap(info)) {
            BitMap4 nullBitMap = new BitMap4(info.elementCount());
            ReservedBuffer nullBitMapBuffer = context.reserve(nullBitMap.marshalledLength());
            int currentElement = 0;
            while (objects.moveNext()) {
                Object current = objects.current();
                if (current == null) {
                    nullBitMap.setTrue(currentElement);
                } else {
                    context.writeObject(this.delegateTypeHandler(), current);
                }
                ++currentElement;
            }
            nullBitMapBuffer.writeBytes(nullBitMap.bytes());
        } else {
            while (objects.moveNext()) {
                context.writeObject(this.delegateTypeHandler(), objects.current());
            }
        }
    }

    protected void analyzeDimensions(ObjectContainerBase container, Object obj, ArrayInfo info) {
        int[] dim = this.arrayReflector(container).dimensions(obj);
        ((MultidimensionalArrayInfo)info).dimensions(dim);
        info.elementCount(MultidimensionalArrayHandler.elementCount(dim));
    }

    public TypeHandler4 unversionedTemplate() {
        return new MultidimensionalArrayHandler();
    }
}

