/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClientMessageDispatcher;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.MClassID;
import com.db4o.internal.cs.messages.MClassMeta;
import com.db4o.internal.cs.messages.MClassMetadataIdForName;
import com.db4o.internal.cs.messages.MClassNameForID;
import com.db4o.internal.cs.messages.MClose;
import com.db4o.internal.cs.messages.MCloseSocket;
import com.db4o.internal.cs.messages.MCommit;
import com.db4o.internal.cs.messages.MCommitSystemTransaction;
import com.db4o.internal.cs.messages.MCommittedCallBackRegistry;
import com.db4o.internal.cs.messages.MCommittedInfo;
import com.db4o.internal.cs.messages.MCreateClass;
import com.db4o.internal.cs.messages.MDelete;
import com.db4o.internal.cs.messages.MDeleteBlobFile;
import com.db4o.internal.cs.messages.MError;
import com.db4o.internal.cs.messages.MFailed;
import com.db4o.internal.cs.messages.MGetAll;
import com.db4o.internal.cs.messages.MGetClasses;
import com.db4o.internal.cs.messages.MGetInternalIDs;
import com.db4o.internal.cs.messages.MGetThreadID;
import com.db4o.internal.cs.messages.MIDList;
import com.db4o.internal.cs.messages.MIdentity;
import com.db4o.internal.cs.messages.MInstanceCount;
import com.db4o.internal.cs.messages.MIsAlive;
import com.db4o.internal.cs.messages.MLength;
import com.db4o.internal.cs.messages.MLogin;
import com.db4o.internal.cs.messages.MLoginOK;
import com.db4o.internal.cs.messages.MNull;
import com.db4o.internal.cs.messages.MOK;
import com.db4o.internal.cs.messages.MObjectByUuid;
import com.db4o.internal.cs.messages.MObjectSetFetch;
import com.db4o.internal.cs.messages.MObjectSetFinalized;
import com.db4o.internal.cs.messages.MObjectSetGetId;
import com.db4o.internal.cs.messages.MObjectSetIndexOf;
import com.db4o.internal.cs.messages.MObjectSetReset;
import com.db4o.internal.cs.messages.MObjectSetSize;
import com.db4o.internal.cs.messages.MPing;
import com.db4o.internal.cs.messages.MPong;
import com.db4o.internal.cs.messages.MPrefetchIDs;
import com.db4o.internal.cs.messages.MProcessDeletes;
import com.db4o.internal.cs.messages.MQueryExecute;
import com.db4o.internal.cs.messages.MQueryResult;
import com.db4o.internal.cs.messages.MRaiseVersion;
import com.db4o.internal.cs.messages.MReadBlob;
import com.db4o.internal.cs.messages.MReadBytes;
import com.db4o.internal.cs.messages.MReadMultipleObjects;
import com.db4o.internal.cs.messages.MReadObject;
import com.db4o.internal.cs.messages.MReleaseSemaphore;
import com.db4o.internal.cs.messages.MRollback;
import com.db4o.internal.cs.messages.MRuntimeException;
import com.db4o.internal.cs.messages.MSetSemaphore;
import com.db4o.internal.cs.messages.MSuccess;
import com.db4o.internal.cs.messages.MSwitchToFile;
import com.db4o.internal.cs.messages.MSwitchToMainFile;
import com.db4o.internal.cs.messages.MTaDelete;
import com.db4o.internal.cs.messages.MTaIsDeleted;
import com.db4o.internal.cs.messages.MUseTransaction;
import com.db4o.internal.cs.messages.MUserMessage;
import com.db4o.internal.cs.messages.MVersion;
import com.db4o.internal.cs.messages.MWriteBatchedMessages;
import com.db4o.internal.cs.messages.MWriteBlob;
import com.db4o.internal.cs.messages.MWriteNew;
import com.db4o.internal.cs.messages.MWriteUpdate;
import com.db4o.internal.cs.messages.MWriteUpdateDeleteMembers;
import com.db4o.internal.cs.messages.MessageDispatcher;
import com.db4o.internal.cs.messages.MsgBlob;
import com.db4o.internal.cs.messages.MsgObject;

public abstract class Msg
implements Cloneable {
    static int _messageIdGenerator = 1;
    private static Msg[] _messages = new Msg[70];
    int _msgID = _messageIdGenerator++;
    String _name;
    private Transaction _trans;
    private MessageDispatcher _messageDispatcher;
    public static final MRuntimeException RUNTIME_EXCEPTION = new MRuntimeException();
    public static final MClassID CLASS_ID = new MClassID();
    public static final MClassMetadataIdForName CLASS_METADATA_ID_FOR_NAME = new MClassMetadataIdForName();
    public static final MClassNameForID CLASS_NAME_FOR_ID = new MClassNameForID();
    public static final MClose CLOSE = new MClose();
    public static final MCloseSocket CLOSE_SOCKET = new MCloseSocket();
    public static final MCommit COMMIT = new MCommit();
    public static final MCommittedCallBackRegistry COMMITTED_CALLBACK_REGISTER = new MCommittedCallBackRegistry();
    public static final MCommittedInfo COMMITTED_INFO = new MCommittedInfo();
    public static final MCommitSystemTransaction COMMIT_SYSTEMTRANS = new MCommitSystemTransaction();
    public static final MCreateClass CREATE_CLASS = new MCreateClass();
    public static final MClassMeta CLASS_META = new MClassMeta();
    public static final MVersion CURRENT_VERSION = new MVersion();
    public static final MDelete DELETE = new MDelete();
    public static final MError ERROR = new MError();
    public static final MFailed FAILED = new MFailed();
    public static final MGetAll GET_ALL = new MGetAll();
    public static final MGetClasses GET_CLASSES = new MGetClasses();
    public static final MGetInternalIDs GET_INTERNAL_IDS = new MGetInternalIDs();
    public static final MGetThreadID GET_THREAD_ID = new MGetThreadID();
    public static final MIDList ID_LIST = new MIDList();
    public static final MIdentity IDENTITY = new MIdentity();
    public static final MIsAlive IS_ALIVE = new MIsAlive();
    public static final MLength LENGTH = new MLength();
    public static final MLogin LOGIN = new MLogin();
    public static final MLoginOK LOGIN_OK = new MLoginOK();
    public static final MNull NULL = new MNull();
    public static final MObjectByUuid OBJECT_BY_UUID = new MObjectByUuid();
    public static final MsgObject OBJECT_TO_CLIENT = new MsgObject();
    public static final MObjectSetFetch OBJECTSET_FETCH = new MObjectSetFetch();
    public static final MObjectSetFinalized OBJECTSET_FINALIZED = new MObjectSetFinalized();
    public static final MObjectSetGetId OBJECTSET_GET_ID = new MObjectSetGetId();
    public static final MObjectSetIndexOf OBJECTSET_INDEXOF = new MObjectSetIndexOf();
    public static final MObjectSetReset OBJECTSET_RESET = new MObjectSetReset();
    public static final MObjectSetSize OBJECTSET_SIZE = new MObjectSetSize();
    public static final MOK OK = new MOK();
    public static final MPing PING = new MPing();
    public static final MPong PONG = new MPong();
    public static final MPrefetchIDs PREFETCH_IDS = new MPrefetchIDs();
    public static final MProcessDeletes PROCESS_DELETES = new MProcessDeletes();
    public static final MQueryExecute QUERY_EXECUTE = new MQueryExecute();
    public static final MQueryResult QUERY_RESULT = new MQueryResult();
    public static final MRaiseVersion RAISE_VERSION = new MRaiseVersion();
    public static final MReadBlob READ_BLOB = new MReadBlob();
    public static final MReadBytes READ_BYTES = new MReadBytes();
    public static final MReadMultipleObjects READ_MULTIPLE_OBJECTS = new MReadMultipleObjects();
    public static final MReadObject READ_OBJECT = new MReadObject();
    public static final MReleaseSemaphore RELEASE_SEMAPHORE = new MReleaseSemaphore();
    public static final MRollback ROLLBACK = new MRollback();
    public static final MSetSemaphore SET_SEMAPHORE = new MSetSemaphore();
    public static final MSuccess SUCCESS = new MSuccess();
    public static final MSwitchToFile SWITCH_TO_FILE = new MSwitchToFile();
    public static final MSwitchToMainFile SWITCH_TO_MAIN_FILE = new MSwitchToMainFile();
    public static final MTaDelete TA_DELETE = new MTaDelete();
    public static final MTaIsDeleted TA_IS_DELETED = new MTaIsDeleted();
    public static final MUserMessage USER_MESSAGE = new MUserMessage();
    public static final MUseTransaction USE_TRANSACTION = new MUseTransaction();
    public static final MWriteBlob WRITE_BLOB = new MWriteBlob();
    public static final MWriteNew WRITE_NEW = new MWriteNew();
    public static final MWriteUpdate WRITE_UPDATE = new MWriteUpdate();
    public static final MWriteUpdateDeleteMembers WRITE_UPDATE_DELETE_MEMBERS = new MWriteUpdateDeleteMembers();
    public static final MWriteBatchedMessages WRITE_BATCHED_MESSAGES = new MWriteBatchedMessages();
    public static final MsgBlob DELETE_BLOB_FILE = new MDeleteBlobFile();
    public static final MInstanceCount INSTANCE_COUNT = new MInstanceCount();

    Msg() {
        Msg._messages[this._msgID] = this;
    }

    Msg(String aName) {
        this();
        this._name = aName;
    }

    public static Msg getMessage(int id) {
        return _messages[id];
    }

    public final Msg publicClone() {
        try {
            return (Msg)this.clone();
        }
        catch (CloneNotSupportedException e) {
            Exceptions4.shouldNeverHappen();
            return null;
        }
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this._msgID == ((Msg)obj)._msgID;
    }

    public int hashCode() {
        return this._msgID;
    }

    public ByteArrayBuffer getByteLoad() {
        return null;
    }

    final String getName() {
        if (this._name == null) {
            return this.getClass().getName();
        }
        return this._name;
    }

    protected LocalTransaction serverTransaction() {
        return (LocalTransaction)this._trans;
    }

    protected Transaction transaction() {
        return this._trans;
    }

    protected LocalObjectContainer file() {
        return (LocalObjectContainer)this.stream();
    }

    protected ObjectContainerBase stream() {
        return this.transaction().container();
    }

    protected Object streamLock() {
        return this.stream().lock();
    }

    protected Config4Impl config() {
        return this.stream().config();
    }

    protected static StatefulBuffer readMessageBuffer(Transaction trans, Socket4 sock) throws Db4oIOException {
        return Msg.readMessageBuffer(trans, sock, 9);
    }

    protected static StatefulBuffer readMessageBuffer(Transaction trans, Socket4 sock, int length) throws Db4oIOException {
        StatefulBuffer buffer = new StatefulBuffer(trans, length);
        int offset = 0;
        while (length > 0) {
            int read = sock.read(buffer._buffer, offset, length);
            if (read < 0) {
                throw new Db4oIOException();
            }
            offset += read;
            length -= read;
        }
        return buffer;
    }

    public static final Msg readMessage(MessageDispatcher messageDispatcher, Transaction trans, Socket4 sock) throws Db4oIOException {
        StatefulBuffer reader = Msg.readMessageBuffer(trans, sock);
        Msg message = _messages[reader.readInt()].readPayLoad(messageDispatcher, trans, sock, reader);
        return message;
    }

    Msg readPayLoad(MessageDispatcher messageDispatcher, Transaction a_trans, Socket4 sock, ByteArrayBuffer reader) {
        Msg msg = this.publicClone();
        msg.setMessageDispatcher(messageDispatcher);
        msg.setTransaction(this.checkParentTransaction(a_trans, reader));
        return msg;
    }

    protected final Transaction checkParentTransaction(Transaction a_trans, ByteArrayBuffer reader) {
        if (reader.readByte() == 115 && a_trans.parentTransaction() != null) {
            return a_trans.parentTransaction();
        }
        return a_trans;
    }

    public final void setTransaction(Transaction aTrans) {
        this._trans = aTrans;
    }

    public final String toString() {
        return this.getName();
    }

    public void write(Msg msg) {
        this._messageDispatcher.write(msg);
    }

    public void writeException(RuntimeException e) {
        this.write(RUNTIME_EXCEPTION.getWriterForSingleObject(this.transaction(), e));
    }

    public void respondInt(int response) {
        this.write(ID_LIST.getWriterForInt(this.transaction(), response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Socket4 sock) {
        if (null == sock) {
            throw new ArgumentNullException();
        }
        Socket4 socket4 = sock;
        synchronized (socket4) {
            try {
                sock.write(this.payLoad()._buffer);
                sock.flush();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public StatefulBuffer payLoad() {
        StatefulBuffer writer = new StatefulBuffer(this.transaction(), 9);
        writer.writeInt(this._msgID);
        return writer;
    }

    public MessageDispatcher messageDispatcher() {
        return this._messageDispatcher;
    }

    public ServerMessageDispatcher serverMessageDispatcher() {
        if (this._messageDispatcher instanceof ServerMessageDispatcher) {
            return (ServerMessageDispatcher)this._messageDispatcher;
        }
        throw new IllegalStateException();
    }

    public ClientMessageDispatcher clientMessageDispatcher() {
        if (this._messageDispatcher instanceof ClientMessageDispatcher) {
            return (ClientMessageDispatcher)this._messageDispatcher;
        }
        throw new IllegalStateException();
    }

    public void setMessageDispatcher(MessageDispatcher messageDispatcher) {
        this._messageDispatcher = messageDispatcher;
    }

    public void logMsg(int msgCode, String msg) {
        this.stream().logMsg(msgCode, msg);
    }
}

