/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.ObjectSet;
import com.db4o.User;
import com.db4o.config.Configuration;
import com.db4o.config.NativeSocketFactory;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.ExtObjectServer;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.network.ServerSocket4;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.EmbeddedClientObjectContainer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.BroadcastFilter;
import com.db4o.internal.cs.ClientTransactionHandle;
import com.db4o.internal.cs.ClientTransactionPool;
import com.db4o.internal.cs.CommittedCallbacksDispatcher;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.ServerMessageDispatcherImpl;
import com.db4o.internal.cs.messages.MCommittedInfo;
import com.db4o.internal.cs.messages.Msg;
import java.io.IOException;

public class ObjectServerImpl
implements ObjectServer,
ExtObjectServer,
Runnable {
    private static final int START_THREAD_WAIT_TIMEOUT = 5000;
    private final String _name;
    private ServerSocket4 _serverSocket;
    private int _port;
    private int i_threadIDGen = 1;
    private final Collection4 _dispatchers = new Collection4();
    LocalObjectContainer _container;
    ClientTransactionPool _transactionPool;
    private final Object _startupLock = new Object();
    private Config4Impl _config;
    private BlockingQueue _committedInfosQueue = new BlockingQueue();
    private CommittedCallbacksDispatcher _committedCallbacksDispatcher;
    private boolean _caresAboutCommitted;
    private final NativeSocketFactory _socketFactory;
    private final boolean _isEmbeddedServer;

    public ObjectServerImpl(LocalObjectContainer container, int port, NativeSocketFactory socketFactory) {
        this(container, port < 0 ? 0 : port, port == 0, socketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectServerImpl(LocalObjectContainer container, int port, boolean isEmbeddedServer, NativeSocketFactory socketFactory) {
        this._isEmbeddedServer = isEmbeddedServer;
        this._socketFactory = socketFactory;
        this._container = container;
        this._transactionPool = new ClientTransactionPool(container);
        this._port = port;
        this._config = this._container.configImpl();
        this._name = "db4o ServerSocket FILE: " + container.toString() + "  PORT:" + this._port;
        this._container.setServer(true);
        this.configureObjectServer();
        this._container.classCollection().checkAllClassChanges();
        boolean ok = false;
        try {
            this.ensureLoadStaticClass();
            this.startCommittedCallbackThread(this._committedInfosQueue);
            this.startServer();
            ok = true;
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer() {
        if (this.isEmbeddedServer()) {
            return;
        }
        Object object = this._startupLock;
        synchronized (object) {
            this.startServerSocket();
            this.startServerThread();
            boolean started = false;
            while (!started) {
                try {
                    this._startupLock.wait(5000L);
                    started = true;
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerThread() {
        Object object = this._startupLock;
        synchronized (object) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void startServerSocket() {
        try {
            this._serverSocket = new ServerSocket4(this._socketFactory, this._port);
            this._port = this._serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        this._serverSocket.setSoTimeout(this._config.timeoutServerSocket());
    }

    private boolean isEmbeddedServer() {
        return this._isEmbeddedServer;
    }

    private void ensureLoadStaticClass() {
        this._container.produceClassMetadata(this._container._handlers.ICLASS_STATICCLASS);
    }

    private void configureObjectServer() {
        this._config.callbacks(false);
        this._config.isServer(true);
        this._config.objectClass(User.class).minimumActivationDepth(1);
    }

    public void backup(String path) throws IOException {
        this._container.backup(path);
    }

    final void checkClosed() {
        if (this._container == null) {
            Exceptions4.throwRuntimeException(20, this._name);
        }
        this._container.checkClosed();
    }

    public synchronized boolean close() {
        this.closeServerSocket();
        this.stopCommittedCallbacksDispatcher();
        this.closeMessageDispatchers();
        return this.closeFile();
    }

    private void stopCommittedCallbacksDispatcher() {
        if (this._committedCallbacksDispatcher != null) {
            this._committedCallbacksDispatcher.stop();
        }
    }

    private boolean closeFile() {
        if (this._container != null) {
            this._transactionPool.close();
            this._container = null;
        }
        return true;
    }

    private void closeMessageDispatchers() {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            try {
                ((ServerMessageDispatcher)i.current()).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        i = this.iterateDispatchers();
        while (i.moveNext()) {
            try {
                ((Thread)i.current()).join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator4 iterateDispatchers() {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            return new Collection4(this._dispatchers).iterator();
        }
    }

    private void closeServerSocket() {
        try {
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._serverSocket = null;
    }

    public Configuration configure() {
        return this._config;
    }

    public ExtObjectServer ext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessageDispatcherImpl findThread(int a_threadID) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            Iterator4 i = this._dispatchers.iterator();
            while (i.moveNext()) {
                ServerMessageDispatcherImpl serverThread = (ServerMessageDispatcherImpl)i.current();
                if (serverThread._threadID != a_threadID) continue;
                return serverThread;
            }
        }
        return null;
    }

    Transaction findTransaction(int threadID) {
        ServerMessageDispatcherImpl dispatcher = this.findThread(threadID);
        return dispatcher == null ? null : dispatcher.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void grantAccess(String userName, String password) {
        this.checkClosed();
        Object object = this._container._lock;
        synchronized (object) {
            User existing = this.getUser(userName);
            if (existing != null) {
                this.setPassword(existing, password);
            } else {
                this.addUser(userName, password);
            }
            this._container.commit();
        }
    }

    private void addUser(String userName, String password) {
        this._container.store(new User(userName, password));
    }

    private void setPassword(User existing, String password) {
        existing.password = password;
        this._container.store(existing);
    }

    public User getUser(String userName) {
        ObjectSet result = this.queryUsers(userName);
        if (!result.hasNext()) {
            return null;
        }
        return (User)result.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSet queryUsers(String userName) {
        this._container.showInternalClasses(true);
        try {
            ObjectSet objectSet = this._container.queryByExample(new User(userName, null));
            return objectSet;
        }
        finally {
            this._container.showInternalClasses(false);
        }
    }

    public ObjectContainer objectContainer() {
        return this._container;
    }

    public ObjectContainer openClient() {
        return this.openClient(Db4o.cloneConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectContainer openClient(Configuration config) {
        this.checkClosed();
        Object object = this._container._lock;
        synchronized (object) {
            return new EmbeddedClientObjectContainer(this._container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(ServerMessageDispatcherImpl dispatcher) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            this._dispatchers.remove(dispatcher);
            this.checkCaresAboutCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void revokeAccess(String userName) {
        this.checkClosed();
        Object object = this._container._lock;
        synchronized (object) {
            this.deleteUsers(userName);
            this._container.commit();
        }
    }

    private void deleteUsers(String userName) {
        ObjectSet set = this.queryUsers(userName);
        while (set.hasNext()) {
            this._container.delete(set.next());
        }
    }

    public void run() {
        this.setThreadName();
        this.logListeningOnPort();
        this.notifyThreadStarted();
        this.listen();
    }

    private void startCommittedCallbackThread(BlockingQueue committedInfosQueue) {
        if (this.isEmbeddedServer()) {
            return;
        }
        this._committedCallbacksDispatcher = new CommittedCallbacksDispatcher(this, committedInfosQueue);
        Thread thread = new Thread(this._committedCallbacksDispatcher);
        thread.setName("committed callback thread");
        thread.setDaemon(true);
        thread.start();
    }

    private void setThreadName() {
        Thread.currentThread().setName(this._name);
    }

    private void listen() {
        while (this._serverSocket != null) {
            try {
                ServerMessageDispatcherImpl messageDispatcher = new ServerMessageDispatcherImpl(this, new ClientTransactionHandle(this._transactionPool), this._serverSocket.accept(), this.newThreadId(), false, this._container.lock());
                this.addServerMessageDispatcher(messageDispatcher);
                messageDispatcher.startDispatcher();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThreadStarted() {
        Object object = this._startupLock;
        synchronized (object) {
            this._startupLock.notifyAll();
        }
    }

    private void logListeningOnPort() {
        this._container.logMsg(31, "" + this._serverSocket.getLocalPort());
    }

    private int newThreadId() {
        return this.i_threadIDGen++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerMessageDispatcher(ServerMessageDispatcher thread) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            this._dispatchers.add(thread);
            this.checkCaresAboutCommitted();
        }
    }

    public void addCommittedInfoMsg(MCommittedInfo message) {
        this._committedInfosQueue.add(message);
    }

    public void broadcastMsg(Msg message, BroadcastFilter filter) {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            ServerMessageDispatcher dispatcher = (ServerMessageDispatcher)i.current();
            if (!filter.accept(dispatcher)) continue;
            dispatcher.write(message);
        }
    }

    public boolean caresAboutCommitted() {
        return this._caresAboutCommitted;
    }

    public void checkCaresAboutCommitted() {
        this._caresAboutCommitted = this.anyDispatcherCaresAboutCommitted();
    }

    private boolean anyDispatcherCaresAboutCommitted() {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            ServerMessageDispatcher dispatcher = (ServerMessageDispatcher)i.current();
            if (!dispatcher.caresAboutCommitted()) continue;
            return true;
        }
        return false;
    }

    public int port() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clientCount() {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            return this._dispatchers.size();
        }
    }
}

