/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public final class StatefulBuffer
extends ByteArrayBuffer {
    private int i_address;
    private int _addressOffset;
    private int i_cascadeDelete;
    private int i_id;
    private ActivationDepth i_instantionDepth;
    private int i_length;
    Transaction i_trans;
    private int i_updateDepth = 1;
    public int _payloadOffset;

    public StatefulBuffer(Transaction a_trans, int a_initialBufferSize) {
        this.i_trans = a_trans;
        this.i_length = a_initialBufferSize;
        this._buffer = new byte[this.i_length];
    }

    public StatefulBuffer(Transaction a_trans, int address, int length) {
        this(a_trans, length);
        this.i_address = address;
    }

    public StatefulBuffer(Transaction trans, Slot slot) {
        this(trans, slot.address(), slot.length());
    }

    public StatefulBuffer(Transaction trans, Pointer4 pointer) {
        this(trans, pointer._slot);
        this.i_id = pointer._id;
    }

    public void debugCheckBytes() {
    }

    public int getAddress() {
        return this.i_address;
    }

    public int addressOffset() {
        return this._addressOffset;
    }

    public int getID() {
        return this.i_id;
    }

    public ActivationDepth getInstantiationDepth() {
        return this.i_instantionDepth;
    }

    public int length() {
        return this.i_length;
    }

    public ObjectContainerBase container() {
        return this.i_trans.container();
    }

    public LocalObjectContainer file() {
        return ((LocalTransaction)this.i_trans).file();
    }

    public Transaction transaction() {
        return this.i_trans;
    }

    public int getUpdateDepth() {
        return this.i_updateDepth;
    }

    public byte[] getWrittenBytes() {
        byte[] bytes = new byte[this._offset];
        System.arraycopy(this._buffer, 0, bytes, 0, this._offset);
        return bytes;
    }

    public int preparePayloadRead() {
        int newPayLoadOffset = this.readInt();
        int length = this.readInt();
        int linkOffSet = this._offset;
        this._offset = newPayLoadOffset;
        this._payloadOffset += length;
        return linkOffSet;
    }

    public void read() throws Db4oIOException {
        this.container().readBytes(this._buffer, this.i_address, this._addressOffset, this.i_length);
    }

    public final StatefulBuffer readEmbeddedObject() throws Db4oIOException {
        int id = this.readInt();
        int length = this.readInt();
        if (id == 0) {
            return null;
        }
        StatefulBuffer bytes = null;
        bytes = this.container().readWriterByAddress(this.i_trans, id, length);
        if (bytes != null) {
            bytes.setID(id);
        }
        if (bytes != null) {
            bytes.setUpdateDepth(this.getUpdateDepth());
            bytes.setInstantiationDepth(this.getInstantiationDepth());
        }
        return bytes;
    }

    public final StatefulBuffer readYapBytes() {
        int length = this.readInt();
        if (length == 0) {
            return null;
        }
        StatefulBuffer yb = new StatefulBuffer(this.i_trans, length);
        System.arraycopy(this._buffer, this._offset, yb._buffer, 0, length);
        this._offset += length;
        return yb;
    }

    public void removeFirstBytes(int aLength) {
        this.i_length -= aLength;
        byte[] temp = new byte[this.i_length];
        System.arraycopy(this._buffer, aLength, temp, 0, this.i_length);
        this._buffer = temp;
        this._offset -= aLength;
        if (this._offset < 0) {
            this._offset = 0;
        }
    }

    public void address(int a_address) {
        this.i_address = a_address;
    }

    public void setID(int a_id) {
        this.i_id = a_id;
    }

    public void setInstantiationDepth(ActivationDepth a_depth) {
        this.i_instantionDepth = a_depth;
    }

    public void setTransaction(Transaction aTrans) {
        this.i_trans = aTrans;
    }

    public void setUpdateDepth(int a_depth) {
        this.i_updateDepth = a_depth;
    }

    public void slotDelete() {
        this.i_trans.slotDelete(this.i_id, this.slot());
    }

    public void trim4(int a_offset, int a_length) {
        byte[] temp = new byte[a_length];
        System.arraycopy(this._buffer, a_offset, temp, 0, a_length);
        this._buffer = temp;
        this.i_length = a_length;
    }

    public void useSlot(int a_adress) {
        this.i_address = a_adress;
        this._offset = 0;
    }

    public void useSlot(int address, int length) {
        this.useSlot(new Slot(address, length));
    }

    public void useSlot(Slot slot) {
        this.i_address = slot.address();
        this._offset = 0;
        if (slot.length() > this._buffer.length) {
            this._buffer = new byte[slot.length()];
        }
        this.i_length = slot.length();
    }

    public void useSlot(int a_id, int a_adress, int a_length) {
        this.i_id = a_id;
        this.useSlot(a_adress, a_length);
    }

    public void write() {
        this.file().writeBytes(this, this.i_address, this._addressOffset);
    }

    public void writeEmbeddedNull() {
        this.writeInt(0);
        this.writeInt(0);
    }

    public void writeEncrypt() {
        this.file().writeEncrypt(this, this.i_address, this._addressOffset);
    }

    public void writePayload(StatefulBuffer payLoad, boolean topLevel) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(payLoad.length(), topLevel);
        System.arraycopy(payLoad._buffer, 0, this._buffer, this._payloadOffset, payLoad._buffer.length);
        this.transferPayLoadAddress(payLoad, this._payloadOffset);
        this._payloadOffset += payLoad._buffer.length;
    }

    private void checkMinimumPayLoadOffsetAndWritePointerAndLength(int length, boolean alignToBlockSize) {
        if (this._payloadOffset <= this._offset + 8) {
            this._payloadOffset = this._offset + 8;
        }
        if (alignToBlockSize) {
            this._payloadOffset = this.container().blockAlignedBytes(this._payloadOffset);
        }
        this.writeInt(this._payloadOffset);
        this.writeInt(length);
    }

    public int reserveAndPointToPayLoadSlot(int length) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(length, false);
        int linkOffset = this._offset;
        this._offset = this._payloadOffset;
        this._payloadOffset += length;
        return linkOffset;
    }

    public ByteArrayBuffer readPayloadWriter(int offset, int length) {
        StatefulBuffer payLoad = new StatefulBuffer(this.i_trans, 0, length);
        System.arraycopy(this._buffer, offset, payLoad._buffer, 0, length);
        this.transferPayLoadAddress(payLoad, offset);
        return payLoad;
    }

    private void transferPayLoadAddress(StatefulBuffer toWriter, int offset) {
        int blockedOffset = offset / this.container().blockSize();
        toWriter.i_id = toWriter.i_address = this.i_address + blockedOffset;
        toWriter._addressOffset = this._addressOffset;
    }

    void writeShortString(String a_string) {
        this.writeShortString(this.i_trans, a_string);
    }

    public void moveForward(int length) {
        this._addressOffset += length;
    }

    public void writeForward() {
        this.write();
        this._addressOffset += this.i_length;
        this._offset = 0;
    }

    public String toString() {
        return "id " + this.i_id + " adr " + this.i_address + " len " + this.i_length;
    }

    public void noXByteCheck() {
    }

    public void writeIDs(IntIterator4 idIterator, int maxCount) {
        int savedOffset = this._offset;
        this.writeInt(0);
        int actualCount = 0;
        while (idIterator.moveNext()) {
            this.writeInt(idIterator.currentInt());
            if (++actualCount < maxCount) continue;
        }
        int secondSavedOffset = this._offset;
        this._offset = savedOffset;
        this.writeInt(actualCount);
        this._offset = secondSavedOffset;
    }

    public Slot slot() {
        return new Slot(this.i_address, this.i_length);
    }

    public Pointer4 pointer() {
        return new Pointer4(this.i_id, this.slot());
    }

    public int cascadeDeletes() {
        return this.i_cascadeDelete;
    }

    public void setCascadeDeletes(int depth) {
        this.i_cascadeDelete = depth;
    }
}

