/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.IntIterator4Impl;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;

public class IntArrayList
implements Iterable4 {
    protected int[] i_content;
    private int i_count;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialSize) {
        this.i_content = new int[initialSize];
    }

    public void add(int a_value) {
        this.ensureCapacity();
        this.i_content[this.i_count++] = a_value;
    }

    public void add(int index, int a_value) {
        this.ensureCapacity();
        System.arraycopy(this.i_content, index, this.i_content, index + 1, this.i_count - index);
        this.i_content[index] = a_value;
        ++this.i_count;
    }

    private void ensureCapacity() {
        if (this.i_count >= this.i_content.length) {
            int inc = this.i_content.length / 2;
            if (inc < 10) {
                inc = 10;
            }
            int[] temp = new int[this.i_content.length + inc];
            System.arraycopy(this.i_content, 0, temp, 0, this.i_content.length);
            this.i_content = temp;
        }
    }

    public int indexOf(int a_value) {
        for (int i = 0; i < this.i_count; ++i) {
            if (this.i_content[i] != a_value) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.i_count;
    }

    public long[] asLong() {
        long[] longs = new long[this.i_count];
        for (int i = 0; i < this.i_count; ++i) {
            longs[i] = this.i_content[i];
        }
        return longs;
    }

    public IntIterator4 intIterator() {
        return new IntIterator4Impl(this.i_content, this.i_count);
    }

    public Iterator4 iterator() {
        return this.intIterator();
    }

    public int get(int index) {
        return this.i_content[index];
    }

    public void swap(int left, int right) {
        if (left != right) {
            int swap = this.i_content[left];
            this.i_content[left] = this.i_content[right];
            this.i_content[right] = swap;
        }
    }
}

