/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.file;

import com.db4o.instrumentation.file.FileInstrumentationClassSource;
import com.db4o.instrumentation.file.FilePathRoot;
import com.db4o.instrumentation.file.InstrumentationClassSource;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultFilePathRoot
implements FilePathRoot {
    private final String[] _rootDirs;
    private final String _extension;

    public DefaultFilePathRoot(String[] rootDirs) {
        this(rootDirs, "");
    }

    public DefaultFilePathRoot(String[] rootDirs, String extension) {
        this._rootDirs = rootDirs;
        this._extension = extension;
    }

    public Iterator files() {
        return new FileSystemIterator(this._rootDirs, this._extension);
    }

    public String[] rootDirs() {
        return this._rootDirs;
    }

    private static class FileSystemIterator
    implements Iterator {
        private final String _extension;
        private LinkedList _stack = new LinkedList();

        public FileSystemIterator(String[] roots, String extension) {
            this._extension = extension;
            for (int rootIdx = 0; rootIdx < roots.length; ++rootIdx) {
                File root = new File(roots[rootIdx]);
                this.push(new FileInstrumentationClassSource(root, root));
            }
            this.advanceQueue();
        }

        public boolean hasNext() {
            return !this._stack.isEmpty();
        }

        public Object next() {
            FileInstrumentationClassSource top = this.pop();
            this.advanceQueue();
            return top;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceQueue() {
            while (!this._stack.isEmpty() && !this.accept(this.peek())) {
                FileInstrumentationClassSource dir = this.pop();
                if (!dir.file().isDirectory()) continue;
                File[] children = dir.file().listFiles();
                for (int childIdx = 0; childIdx < children.length; ++childIdx) {
                    this._stack.addFirst(new FileInstrumentationClassSource(dir.root(), children[childIdx]));
                }
            }
        }

        private boolean accept(FileInstrumentationClassSource file) {
            return file.file().isFile() && file.file().getName().endsWith(this._extension);
        }

        private void push(InstrumentationClassSource root) {
            this._stack.addFirst(root);
        }

        private FileInstrumentationClassSource pop() {
            return (FileInstrumentationClassSource)this._stack.removeFirst();
        }

        private FileInstrumentationClassSource peek() {
            return (FileInstrumentationClassSource)this._stack.getFirst();
        }
    }
}

