/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.bloat;

import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.api.FieldRef;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.ReferenceProvider;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.instrumentation.bloat.BloatFieldRef;
import com.db4o.instrumentation.bloat.BloatMethodRef;
import com.db4o.instrumentation.bloat.BloatTypeRef;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class BloatReferenceProvider
implements ReferenceProvider {
    private Hashtable _types = new Hashtable();

    public MethodRef forMethod(TypeRef declaringType, String methodName, TypeRef[] parameterTypes, TypeRef returnType) {
        Type[] argTypes = BloatTypeRef.bloatTypes(parameterTypes);
        NameAndType nameAndType = new NameAndType(methodName, Type.getType(argTypes, this.bloatType(returnType)));
        return this.forBloatMethod(new MemberRef(this.bloatType(declaringType), nameAndType));
    }

    Type bloatType(Class clazz) {
        return Type.getType(clazz);
    }

    Type bloatType(TypeRef type) {
        return BloatTypeRef.bloatType(type);
    }

    public TypeRef forType(Class type) {
        return this.forBloatType(this.bloatType(type));
    }

    public MethodRef forMethod(Method method) {
        return this.forMethod(this.forType(method.getDeclaringClass()), method.getName(), this.forTypes(method.getParameterTypes()), this.forType(method.getReturnType()));
    }

    private TypeRef[] forTypes(Class[] types) {
        TypeRef[] typeRefs = new TypeRef[types.length];
        for (int i = 0; i < types.length; ++i) {
            typeRefs[i] = this.forType(types[i]);
        }
        return typeRefs;
    }

    public MethodRef forBloatMethod(MemberRef method) {
        return new BloatMethodRef(this, method);
    }

    public TypeRef forBloatType(Type type) {
        BloatTypeRef typeRef = (BloatTypeRef)this._types.get(type.descriptor());
        if (null == typeRef) {
            typeRef = new BloatTypeRef(this, type);
            this._types.put(type.descriptor(), typeRef);
        }
        return typeRef;
    }

    public FieldRef forBloatField(MemberRef field) {
        return new BloatFieldRef(this, field);
    }
}

